/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class PathTest {
    @Test
    public void testPathFromString() {
        Path p = new Path("/my/path");
        Assert.assertEquals((Object)"/my/path", (Object)p.toUri().getPath());
        Assert.assertNull((Object)p.toUri().getScheme());
        p = new Path("/my/path/");
        Assert.assertEquals((Object)"/my/path", (Object)p.toUri().getPath());
        Assert.assertNull((Object)p.toUri().getScheme());
        p = new Path("/my//path/");
        Assert.assertEquals((Object)"/my/path", (Object)p.toUri().getPath());
        Assert.assertNull((Object)p.toUri().getScheme());
        p = new Path("/my//path//a///");
        Assert.assertEquals((Object)"/my/path/a", (Object)p.toUri().getPath());
        Assert.assertNull((Object)p.toUri().getScheme());
        p = new Path("\\my\\path\\\\a\\\\\\");
        Assert.assertEquals((Object)"/my/path/a", (Object)p.toUri().getPath());
        Assert.assertNull((Object)p.toUri().getScheme());
        p = new Path("hdfs:///my/path");
        Assert.assertEquals((Object)"/my/path", (Object)p.toUri().getPath());
        Assert.assertEquals((Object)"hdfs", (Object)p.toUri().getScheme());
        p = new Path("hdfs:///my/path/");
        Assert.assertEquals((Object)"/my/path", (Object)p.toUri().getPath());
        Assert.assertEquals((Object)"hdfs", (Object)p.toUri().getScheme());
        p = new Path("file:///my/path");
        Assert.assertEquals((Object)"/my/path", (Object)p.toUri().getPath());
        Assert.assertEquals((Object)"file", (Object)p.toUri().getScheme());
        p = new Path("C:/my/windows/path");
        Assert.assertEquals((Object)"/C:/my/windows/path", (Object)p.toUri().getPath());
        p = new Path("file:/C:/my/windows/path");
        Assert.assertEquals((Object)"/C:/my/windows/path", (Object)p.toUri().getPath());
        try {
            new Path((String)null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new Path("");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testIsAbsolute() {
        Path p = new Path("/my/abs/path");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("/");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("./my/rel/path");
        Assert.assertFalse((boolean)p.isAbsolute());
        p = new Path("my/rel/path");
        Assert.assertFalse((boolean)p.isAbsolute());
        p = new Path("C:/my/abs/windows/path");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("y:/my/abs/windows/path");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("/y:/my/abs/windows/path");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("b:\\my\\abs\\windows\\path");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("/c:/my/dir");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("/C:/");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("C:");
        Assert.assertFalse((boolean)p.isAbsolute());
        p = new Path("C:/");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("C:my\\relative\\path");
        Assert.assertFalse((boolean)p.isAbsolute());
        p = new Path("\\my\\dir");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path("\\");
        Assert.assertTrue((boolean)p.isAbsolute());
        p = new Path(".\\my\\relative\\path");
        Assert.assertFalse((boolean)p.isAbsolute());
        p = new Path("my\\relative\\path");
        Assert.assertFalse((boolean)p.isAbsolute());
        p = new Path("\\\\myServer\\myDir");
        Assert.assertTrue((boolean)p.isAbsolute());
    }

    @Test
    public void testGetName() {
        Path p = new Path("/my/fancy/path");
        Assert.assertEquals((Object)"path", (Object)p.getName());
        p = new Path("/my/fancy/path/");
        Assert.assertEquals((Object)"path", (Object)p.getName());
        p = new Path("hdfs:///my/path");
        Assert.assertEquals((Object)"path", (Object)p.getName());
        p = new Path("hdfs:///myPath/");
        Assert.assertEquals((Object)"myPath", (Object)p.getName());
        p = new Path("/");
        Assert.assertEquals((Object)"", (Object)p.getName());
        p = new Path("C:/my/windows/path");
        Assert.assertEquals((Object)"path", (Object)p.getName());
        p = new Path("file:/C:/my/windows/path");
        Assert.assertEquals((Object)"path", (Object)p.getName());
    }

    @Test
    public void testGetParent() {
        Path p = new Path("/my/fancy/path");
        Assert.assertEquals((Object)"/my/fancy", (Object)p.getParent().toUri().getPath());
        p = new Path("/my/other/fancy/path/");
        Assert.assertEquals((Object)"/my/other/fancy", (Object)p.getParent().toUri().getPath());
        p = new Path("hdfs:///my/path");
        Assert.assertEquals((Object)"/my", (Object)p.getParent().toUri().getPath());
        p = new Path("hdfs:///myPath/");
        Assert.assertEquals((Object)"/", (Object)p.getParent().toUri().getPath());
        p = new Path("/");
        Assert.assertNull((Object)p.getParent());
        p = new Path("C:/my/windows/path");
        Assert.assertEquals((Object)"/C:/my/windows", (Object)p.getParent().toUri().getPath());
    }

    @Test
    public void testSuffix() {
        Path p = new Path("/my/path");
        p = p.suffix("_123");
        Assert.assertEquals((Object)"/my/path_123", (Object)p.toUri().getPath());
        p = new Path("/my/path/");
        p = p.suffix("/abc");
        Assert.assertEquals((Object)"/my/path/abc", (Object)p.toUri().getPath());
        p = new Path("C:/my/windows/path");
        p = p.suffix("/abc");
        Assert.assertEquals((Object)"/C:/my/windows/path/abc", (Object)p.toUri().getPath());
    }

    @Test
    public void testDepth() {
        Path p = new Path("/my/path");
        Assert.assertEquals((long)2L, (long)p.depth());
        p = new Path("/my/fancy/path/");
        Assert.assertEquals((long)3L, (long)p.depth());
        p = new Path("/my/fancy/fancy/fancy/fancy/fancy/fancy/fancy/fancy/fancy/fancy/path");
        Assert.assertEquals((long)12L, (long)p.depth());
        p = new Path("/");
        Assert.assertEquals((long)0L, (long)p.depth());
        p = new Path("C:/my/windows/path");
        Assert.assertEquals((long)4L, (long)p.depth());
    }

    @Test
    public void testParsing() {
        String scheme = "hdfs";
        String authority = "localhost:8000";
        String path = "/test/test";
        URI u = new Path(scheme + "://" + authority + path).toUri();
        Assert.assertEquals((Object)scheme, (Object)u.getScheme());
        Assert.assertEquals((Object)authority, (Object)u.getAuthority());
        Assert.assertEquals((Object)path, (Object)u.getPath());
        u = new Path(scheme + "://" + path).toUri();
        Assert.assertEquals((Object)scheme, (Object)u.getScheme());
        Assert.assertEquals(null, (Object)u.getAuthority());
        Assert.assertEquals((Object)path, (Object)u.getPath());
        u = new Path(scheme + ":" + path).toUri();
        Assert.assertEquals((Object)scheme, (Object)u.getScheme());
        Assert.assertEquals(null, (Object)u.getAuthority());
        Assert.assertEquals((Object)path, (Object)u.getPath());
        u = new Path(scheme + ":/" + path).toUri();
        Assert.assertEquals((Object)scheme, (Object)u.getScheme());
        Assert.assertEquals((Object)"test", (Object)u.getAuthority());
        Assert.assertEquals((Object)"/test", (Object)u.getPath());
        u = new Path(scheme + ":///" + path).toUri();
        Assert.assertEquals((Object)"hdfs", (Object)u.getScheme());
        Assert.assertEquals(null, (Object)u.getAuthority());
        Assert.assertEquals((Object)path, (Object)u.getPath());
    }

    @Test
    public void testMakeQualified() throws IOException {
        String path = "test/test";
        Path p = new Path(path).makeQualified(FileSystem.getLocalFileSystem());
        URI u = p.toUri();
        Assert.assertEquals((Object)"file", (Object)u.getScheme());
        Assert.assertEquals(null, (Object)u.getAuthority());
        String q = new Path(FileSystem.getLocalFileSystem().getWorkingDirectory().getPath(), path).getPath();
        Assert.assertEquals((Object)q, (Object)u.getPath());
        path = "/test/test";
        p = new Path(path).makeQualified(FileSystem.getLocalFileSystem());
        u = p.toUri();
        Assert.assertEquals((Object)"file", (Object)u.getScheme());
        Assert.assertEquals(null, (Object)u.getAuthority());
        Assert.assertEquals((Object)path, (Object)u.getPath());
    }
}

