/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSplitAssignerTest {
    @Test
    public void testSerialSplitAssignment() {
        try {
            int NUM_SPLITS = 50;
            HashSet<GenericInputSplit> splits = new HashSet<GenericInputSplit>();
            for (int i = 0; i < 50; ++i) {
                splits.add(new GenericInputSplit(i, 50));
            }
            DefaultInputSplitAssigner ia = new DefaultInputSplitAssigner(splits);
            InputSplit is = null;
            while ((is = ia.getNextInputSplit("", 0)) != null) {
                Assert.assertTrue((boolean)splits.remove(is));
            }
            Assert.assertTrue((boolean)splits.isEmpty());
            Assert.assertNull((Object)ia.getNextInputSplit("", 0));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConcurrentSplitAssignment() {
        try {
            int i;
            int NUM_THREADS = 10;
            int NUM_SPLITS = 500;
            int SUM_OF_IDS = 124750;
            HashSet<GenericInputSplit> splits = new HashSet<GenericInputSplit>();
            for (int i2 = 0; i2 < 500; ++i2) {
                splits.add(new GenericInputSplit(i2, 500));
            }
            final DefaultInputSplitAssigner ia = new DefaultInputSplitAssigner(splits);
            final AtomicInteger splitsRetrieved = new AtomicInteger(0);
            final AtomicInteger sumOfIds = new AtomicInteger(0);
            Runnable retriever = new Runnable(){

                @Override
                public void run() {
                    GenericInputSplit split;
                    String host = "";
                    while ((split = (GenericInputSplit)ia.getNextInputSplit(host, 0)) != null) {
                        splitsRetrieved.incrementAndGet();
                        sumOfIds.addAndGet(split.getSplitNumber());
                    }
                }
            };
            Thread[] threads = new Thread[10];
            for (i = 0; i < 10; ++i) {
                threads[i] = new Thread(retriever);
                threads[i].setDaemon(true);
            }
            for (i = 0; i < 10; ++i) {
                threads[i].start();
            }
            for (i = 0; i < 10; ++i) {
                threads[i].join(5000L);
            }
            for (i = 0; i < 10; ++i) {
                if (!threads[i].isAlive()) continue;
                Assert.fail((String)"The concurrency test case is erroneous, the thread did not respond in time.");
            }
            Assert.assertEquals((long)500L, (long)splitsRetrieved.get());
            Assert.assertEquals((long)124750L, (long)sumOfIds.get());
            Assert.assertNull((Object)ia.getNextInputSplit("", 0));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

