/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ByteArrayOutputStreamWithPosTest {
    private static final int BUFFER_SIZE = 32;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ByteArrayOutputStreamWithPos stream;

    @Before
    public void setup() {
        this.stream = new ByteArrayOutputStreamWithPos(32);
    }

    @Test
    public void testSetPositionWhenBufferIsFull() throws Exception {
        this.stream.write(new byte[32]);
        Assert.assertEquals((long)32L, (long)this.stream.getBuf().length);
        Assert.assertEquals((long)32L, (long)this.stream.getPosition());
        this.stream.setPosition(32);
        Assert.assertEquals((long)32L, (long)this.stream.getPosition());
    }

    @Test
    public void testSetNegativePosition() throws Exception {
        this.stream.write(new byte[32]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Position out of bounds");
        this.stream.setPosition(-1);
    }

    @Test
    public void testSetPositionLargerThanBufferSize() throws Exception {
        this.stream.write(new byte[32]);
        Assert.assertEquals((long)32L, (long)this.stream.getBuf().length);
        this.stream.setPosition(33);
        Assert.assertEquals((long)64L, (long)this.stream.getBuf().length);
        Assert.assertEquals((long)33L, (long)this.stream.getPosition());
    }

    @Test
    public void testToString() throws IOException {
        byte[] data = "1234567890".getBytes(ConfigConstants.DEFAULT_CHARSET);
        ByteArrayOutputStreamWithPos stream = new ByteArrayOutputStreamWithPos(data.length);
        stream.write(data);
        Assert.assertArrayEquals((byte[])data, (byte[])stream.toString().getBytes(ConfigConstants.DEFAULT_CHARSET));
        for (int i = 0; i < data.length; ++i) {
            stream.setPosition(i);
            Assert.assertArrayEquals((byte[])Arrays.copyOf(data, i), (byte[])stream.toString().getBytes(ConfigConstants.DEFAULT_CHARSET));
        }
        stream.setPosition(data.length + 1);
        Assert.assertArrayEquals((byte[])Arrays.copyOf(data, data.length + 1), (byte[])stream.toString().getBytes(ConfigConstants.DEFAULT_CHARSET));
    }
}

