/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryUtils;
import org.junit.Assert;
import org.junit.Test;

public class CrossSegmentTypeTest {
    private static final long BYTE_ARRAY_BASE_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(byte[].class);
    private final int pageSize = 32768;

    @Test
    public void testCompareBytesMixedSegments() {
        MemorySegment[] segs1 = CrossSegmentTypeTest.createSegments(32768);
        MemorySegment[] segs2 = CrossSegmentTypeTest.createSegments(32768);
        Random rnd = new Random();
        for (MemorySegment seg1 : segs1) {
            for (MemorySegment seg2 : segs2) {
                this.testCompare(seg1, seg2, rnd);
            }
        }
    }

    private void testCompare(MemorySegment seg1, MemorySegment seg2, Random random) {
        int i;
        Assert.assertEquals((long)32768L, (long)seg1.size());
        Assert.assertEquals((long)32768L, (long)seg2.size());
        byte[] bytes1 = new byte[32768];
        byte[] bytes2 = new byte[32768];
        int stride = 128;
        int shift = 16666;
        for (i = 0; i < 32768; ++i) {
            byte val;
            bytes1[i] = val = (byte)(i / 128 & 0xFF);
            if (i + 16666 >= bytes2.length) continue;
            bytes2[i + 16666] = val;
        }
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (i = 0; i < 1000; ++i) {
            int pos1 = random.nextInt(bytes1.length);
            int pos2 = random.nextInt(bytes2.length);
            int len = Math.min(Math.min(bytes1.length - pos1, bytes2.length - pos2), random.nextInt(655));
            int cmp = seg1.compare(seg2, pos1, pos2, len);
            if (pos1 < pos2 - 16666) {
                Assert.assertTrue((cmp <= 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((cmp >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSwapBytesMixedSegments() {
        int halfPageSize = 16384;
        MemorySegment[] segs1 = CrossSegmentTypeTest.createSegments(32768);
        MemorySegment[] segs2 = CrossSegmentTypeTest.createSegments(16384);
        Random rnd = new Random();
        for (MemorySegment seg1 : segs1) {
            for (MemorySegment seg2 : segs2) {
                this.testSwap(seg1, seg2, rnd, 16384);
            }
        }
    }

    private void testSwap(MemorySegment seg1, MemorySegment seg2, Random random, int smallerSize) {
        int len;
        Assert.assertEquals((long)32768L, (long)seg1.size());
        Assert.assertEquals((long)smallerSize, (long)seg2.size());
        byte[] bytes1 = new byte[32768];
        byte[] bytes2 = new byte[smallerSize];
        Arrays.fill(bytes2, (byte)1);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int pos = 0; pos < smallerSize; pos += len) {
            len = random.nextInt(819);
            len = Math.min(len, smallerSize - pos);
            seg1.swapBytes(new byte[len], seg2, pos + smallerSize, pos, len);
        }
        for (int i = 0; i < smallerSize; ++i) {
            Assert.assertEquals((long)0L, (long)seg1.get(i));
            Assert.assertEquals((long)0L, (long)seg2.get(i));
            Assert.assertEquals((long)1L, (long)seg1.get(i + smallerSize));
        }
    }

    @Test
    public void testCopyMixedSegments() {
        MemorySegment[] segs1 = CrossSegmentTypeTest.createSegments(32768);
        MemorySegment[] segs2 = CrossSegmentTypeTest.createSegments(32768);
        Random rnd = new Random();
        for (MemorySegment seg1 : segs1) {
            for (MemorySegment seg2 : segs2) {
                this.testCopy(seg1, seg2, rnd);
            }
        }
    }

    private static MemorySegment[] createSegments(int size) {
        MemorySegment[] segments = new MemorySegment[]{MemorySegmentFactory.allocateUnpooledSegment((int)size), MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)size), MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)size)};
        return segments;
    }

    private void testCopy(MemorySegment seg1, MemorySegment seg2, Random random) {
        Assert.assertEquals((long)32768L, (long)seg1.size());
        Assert.assertEquals((long)32768L, (long)seg2.size());
        byte[] expected = new byte[32768];
        byte[] actual = new byte[32768];
        byte[] unsafeCopy = new byte[32768];
        MemorySegment unsafeCopySeg = MemorySegmentFactory.allocateUnpooledSegment((int)32768);
        seg1.put(0, expected);
        seg2.put(0, expected);
        for (int i = 0; i < 40; ++i) {
            int numBytes = random.nextInt(1638);
            byte[] bytes = new byte[numBytes];
            random.nextBytes(bytes);
            int thisPos = random.nextInt(32768 - numBytes);
            int otherPos = random.nextInt(32768 - numBytes);
            System.arraycopy(bytes, 0, expected, otherPos, numBytes);
            seg1.put(thisPos, bytes);
            seg1.copyTo(thisPos, seg2, otherPos, numBytes);
            seg1.copyToUnsafe(thisPos, (Object)unsafeCopy, (int)((long)otherPos + BYTE_ARRAY_BASE_OFFSET), numBytes);
            int otherPos2 = random.nextInt(32768 - numBytes);
            unsafeCopySeg.copyFromUnsafe(otherPos2, (Object)unsafeCopy, (int)((long)otherPos + BYTE_ARRAY_BASE_OFFSET), numBytes);
            Assert.assertTrue((boolean)unsafeCopySeg.equalTo(seg2, otherPos2, otherPos, numBytes));
        }
        seg2.get(0, actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        int[] validOffsets = new int[]{0, 1, 29484};
        int[] invalidOffsets = new int[]{-1, 32769, Short.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] validLengths = new int[]{0, 1, 3276, 32768};
        int[] invalidLengths = new int[]{-1, Short.MIN_VALUE, 32769, Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int off1 : validOffsets) {
            for (int off2 : validOffsets) {
                for (int len : invalidLengths) {
                    try {
                        seg1.copyTo(off1, seg2, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg1.copyTo(off2, seg2, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off1, seg1, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off2, seg1, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        for (int off1 : validOffsets) {
            for (int off2 : invalidOffsets) {
                for (int len : validLengths) {
                    try {
                        seg1.copyTo(off1, seg2, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg1.copyTo(off2, seg2, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off1, seg1, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off2, seg1, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        for (int off1 : invalidOffsets) {
            for (int off2 : validOffsets) {
                for (int len : validLengths) {
                    try {
                        seg1.copyTo(off1, seg2, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg1.copyTo(off2, seg2, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off1, seg1, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off2, seg1, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        for (int off1 : invalidOffsets) {
            for (int off2 : invalidOffsets) {
                for (int len : validLengths) {
                    try {
                        seg1.copyTo(off1, seg2, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg1.copyTo(off2, seg2, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off1, seg1, off2, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        seg2.copyTo(off2, seg1, off1, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

