/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.junit.Assert;
import org.junit.Test;

public class MemorySegmentUndersizedTest {
    @Test
    public void testZeroSizeHeapSegment() {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)0);
        MemorySegmentUndersizedTest.testZeroSizeBuffer(segment);
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(segment);
    }

    @Test
    public void testZeroSizeOffHeapSegment() {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)0);
        MemorySegmentUndersizedTest.testZeroSizeBuffer(segment);
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(segment);
    }

    @Test
    public void testZeroSizeOffHeapUnsafeSegment() {
        MemorySegment segment = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)0);
        MemorySegmentUndersizedTest.testZeroSizeBuffer(segment);
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(segment);
    }

    @Test
    public void testSizeOneHeapSegment() {
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(MemorySegmentFactory.allocateUnpooledSegment((int)1));
    }

    @Test
    public void testSizeOneOffHeapSegment() {
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)1));
    }

    @Test
    public void testSizeOneOffHeapUnsafeSegment() {
        MemorySegmentUndersizedTest.testSegmentWithSizeLargerZero(MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)1));
    }

    private static void testZeroSizeBuffer(MemorySegment segment) {
        try {
            segment.put(0, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(0, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }

    private static void testSegmentWithSizeLargerZero(MemorySegment segment) {
        try {
            segment.put(1, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-1, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(8, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-8, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MIN_VALUE, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(1, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(-1, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(8, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(-8, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(Integer.MAX_VALUE, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(Integer.MIN_VALUE, true);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(0, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(1, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(-1, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(8, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(-8, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(Integer.MAX_VALUE, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(Integer.MIN_VALUE, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(0, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(1, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(-1, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(8, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(-8, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(Integer.MAX_VALUE, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(Integer.MIN_VALUE, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(0, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(1, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(-1, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(8, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(-8, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(Integer.MAX_VALUE, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(Integer.MIN_VALUE, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(0, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(1, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(-1, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(8, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(-8, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(Integer.MAX_VALUE, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(Integer.MIN_VALUE, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(0, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(1, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(-1, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(8, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(-8, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(Integer.MAX_VALUE, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(Integer.MIN_VALUE, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(0, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(1, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(-1, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(8, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(Integer.MAX_VALUE, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(Integer.MIN_VALUE, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(-8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(1, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-1, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(8, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-8, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MIN_VALUE, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(1, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-1, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(8, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-8, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MIN_VALUE, new byte[7]);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        ByteBuffer buf = ByteBuffer.allocate(7);
        int numBytes = 3;
        try {
            segment.put(0, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(1, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-1, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(8, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-8, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MIN_VALUE, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(1, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-1, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(8, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-8, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MIN_VALUE, buf, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(new byte[20]));
        DataOutputStream dataOutput = new DataOutputStream(new ByteArrayOutputStream());
        try {
            segment.put((DataInput)dataInput, 0, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put((DataInput)dataInput, 1, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put((DataInput)dataInput, -1, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put((DataInput)dataInput, 8, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put((DataInput)dataInput, -8, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put((DataInput)dataInput, Integer.MAX_VALUE, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put((DataInput)dataInput, Integer.MIN_VALUE, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, 0, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, 1, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, -1, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, 8, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, -8, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, Integer.MAX_VALUE, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get((DataOutput)dataOutput, Integer.MIN_VALUE, 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }
}

