/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OffHeapDirectMemorySegmentTest
extends MemorySegmentTestBase {
    public OffHeapDirectMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)size);
    }

    @Override
    MemorySegment createSegment(int size, Object owner) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)size, (Object)owner);
    }

    @Test
    public void testHeapSegmentSpecifics() {
        int bufSize = 411;
        MemorySegment seg = this.createSegment(411);
        Assert.assertFalse((boolean)seg.isFreed());
        Assert.assertTrue((boolean)seg.isOffHeap());
        Assert.assertEquals((long)411L, (long)seg.size());
        try {
            seg.getArray();
            Assert.fail((String)"should throw an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ByteBuffer buf1 = seg.wrap(1, 2);
        ByteBuffer buf2 = seg.wrap(3, 4);
        Assert.assertNotSame((Object)buf1, (Object)buf2);
        Assert.assertEquals((long)1L, (long)buf1.position());
        Assert.assertEquals((long)3L, (long)buf1.limit());
        Assert.assertEquals((long)3L, (long)buf2.position());
        Assert.assertEquals((long)7L, (long)buf2.limit());
    }
}

