/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class ClassLoaderUtils {
    public static URLClassLoader compileAndLoadJava(File root, String filename, String source) throws IOException {
        return ClassLoaderUtils.withRoot(root).addClass(filename.replaceAll("\\.java", ""), source).build();
    }

    private static URLClassLoader createClassLoader(File root, ClassLoader parent) throws MalformedURLException {
        return new URLClassLoader(new URL[]{root.toURI().toURL()}, parent);
    }

    private static void writeAndCompile(File root, String filename, String source) throws IOException {
        File file = ClassLoaderUtils.writeSourceFile(root, filename, source);
        ClassLoaderUtils.compileClass(file);
    }

    private static File writeSourceFile(File root, String filename, String source) throws IOException {
        File file = new File(root, filename);
        file.getParentFile().mkdirs();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(source);
        fileWriter.close();
        return file;
    }

    public static ClassLoaderBuilder withRoot(File root) {
        return new ClassLoaderBuilder(root);
    }

    private static int compileClass(File sourceFile) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        return compiler.run(null, null, null, "-proc:none", "-classpath", sourceFile.getParent() + ":" + System.getProperty("java.class.path"), sourceFile.getPath());
    }

    public static URL[] getClasspathURLs() {
        String[] cp = System.getProperty("java.class.path").split(File.pathSeparator);
        return (URL[])Arrays.stream(cp).filter(str -> !str.isEmpty()).map(ClassLoaderUtils::parse).toArray(URL[]::new);
    }

    private static URL parse(String fileName) {
        try {
            return new File(fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectAndClassLoader<Serializable> createSerializableObjectFromNewClassLoader() {
        String classSource = "import java.io.Serializable;import java.util.Random;public class TestSerializable implements Serializable {  private static final long serialVersionUID = -3L;  private final long random;  public TestSerializable() {    random = new Random().nextLong();  }  public boolean equals(Object o) {    if (this == o) { return true; }    if ((o == null) || (getClass() != o.getClass())) { return false; }    TestSerializable that = (TestSerializable) o;    return random == random;  }  public int hashCode() {    return (int)(random ^ random >>> 32);  }  public String toString() {    return \"TestSerializable{random=\" + random + '}';  }}";
        return ClassLoaderUtils.createObjectFromNewClassLoader("TestSerializable", Serializable.class, "import java.io.Serializable;import java.util.Random;public class TestSerializable implements Serializable {  private static final long serialVersionUID = -3L;  private final long random;  public TestSerializable() {    random = new Random().nextLong();  }  public boolean equals(Object o) {    if (this == o) { return true; }    if ((o == null) || (getClass() != o.getClass())) { return false; }    TestSerializable that = (TestSerializable) o;    return random == random;  }  public int hashCode() {    return (int)(random ^ random >>> 32);  }  public String toString() {    return \"TestSerializable{random=\" + random + '}';  }}");
    }

    public static ObjectAndClassLoader<Exception> createExceptionObjectFromNewClassLoader() {
        return ClassLoaderUtils.createObjectFromNewClassLoader("TestExceptionForSerialization", Exception.class, "public class TestExceptionForSerialization extends java.lang.Exception {}");
    }

    private static <T> ObjectAndClassLoader<T> createObjectFromNewClassLoader(String testClassName, Class<T> testClass, String source) {
        ObjectAndClassLoader objectAndClassLoader;
        Path classDirPath = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()).toPath();
        URLClassLoader classLoader = null;
        try {
            Files.createDirectories(classDirPath, new FileAttribute[0]);
            classLoader = ClassLoaderUtils.compileAndLoadJava(classDirPath.toFile(), testClassName, source);
            Class<?> clazz = classLoader.loadClass(testClassName);
            T object = clazz.asSubclass(testClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            objectAndClassLoader = new ObjectAndClassLoader(object, classLoader);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Cannot create test class outside system class path", e);
            }
            catch (Throwable throwable) {
                ClassLoaderUtils.tryClose(classLoader);
                ClassLoaderUtils.tryDeleteDirectoryRecursively(classDirPath);
                throw throwable;
            }
        }
        ClassLoaderUtils.tryClose(classLoader);
        ClassLoaderUtils.tryDeleteDirectoryRecursively(classDirPath);
        return objectAndClassLoader;
    }

    private static void tryClose(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void tryDeleteDirectoryRecursively(Path directory) {
        SimpleFileVisitor<Path> deletingVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)deletingVisitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class ObjectAndClassLoader<T> {
        private final T object;
        private final ClassLoader classLoader;

        private ObjectAndClassLoader(T object, ClassLoader classLoader) {
            this.object = object;
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public T getObject() {
            return this.object;
        }
    }

    public static class ClassLoaderBuilder {
        private final File root;
        private final Map<String, String> classes;
        private final Map<String, String> resources;
        private final Map<String, List<String>> services;
        private ClassLoader parent;

        private ClassLoaderBuilder(File root) {
            this.root = root;
            this.classes = new LinkedHashMap<String, String>();
            this.resources = new LinkedHashMap<String, String>();
            this.services = new HashMap<String, List<String>>();
            this.parent = Thread.currentThread().getContextClassLoader();
        }

        public ClassLoaderBuilder addResource(String targetPath, String resource) {
            String oldValue = this.resources.putIfAbsent(targetPath, resource);
            if (oldValue != null) {
                throw new RuntimeException(String.format("Resource with path %s already registered.", resource));
            }
            return this;
        }

        public ClassLoaderBuilder addService(String serviceClass, String implClass) {
            this.services.computeIfAbsent(serviceClass, k -> new ArrayList()).add(implClass);
            return this;
        }

        public ClassLoaderBuilder addClass(String className, String source) {
            String oldValue = this.classes.putIfAbsent(className, source);
            if (oldValue != null) {
                throw new RuntimeException(String.format("Class with name %s already registered.", className));
            }
            return this;
        }

        public ClassLoaderBuilder withParentClassLoader(ClassLoader classLoader) {
            this.parent = classLoader;
            return this;
        }

        public URLClassLoader build() throws IOException {
            for (Map.Entry<String, String> classInfo : this.classes.entrySet()) {
                ClassLoaderUtils.writeAndCompile(this.root, this.createFileName(classInfo.getKey()), classInfo.getValue());
            }
            this.services.forEach((serviceClass, serviceImpls) -> this.resources.putIfAbsent("META-INF/services/" + serviceClass, String.join((CharSequence)"\n", serviceImpls)));
            for (Map.Entry<String, String> resource : this.resources.entrySet()) {
                ClassLoaderUtils.writeSourceFile(this.root, resource.getKey(), resource.getValue());
            }
            return ClassLoaderUtils.createClassLoader(this.root, this.parent);
        }

        private String createFileName(String className) {
            return className + ".java";
        }
    }
}

