/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.migration;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class SchemaCompatibilityTestingSerializer
extends TypeSerializer<Integer> {
    private static final long serialVersionUID = 2588814752302505240L;
    private final Function<TypeSerializer<Integer>, TypeSerializerSchemaCompatibility<Integer>> resolver;
    @Nullable
    private final String tokenForEqualityChecks;
    private static final Function<TypeSerializer<Integer>, TypeSerializerSchemaCompatibility<Integer>> ALWAYS_COMPATIBLE = unused -> TypeSerializerSchemaCompatibility.compatibleAsIs();

    public SchemaCompatibilityTestingSerializer() {
        this(null, ALWAYS_COMPATIBLE);
    }

    public SchemaCompatibilityTestingSerializer(String tokenForEqualityChecks) {
        this(tokenForEqualityChecks, ALWAYS_COMPATIBLE);
    }

    public SchemaCompatibilityTestingSerializer(@Nullable String tokenForEqualityChecks, Function<TypeSerializer<Integer>, TypeSerializerSchemaCompatibility<Integer>> resolver) {
        this.resolver = resolver;
        this.tokenForEqualityChecks = tokenForEqualityChecks;
    }

    public boolean equals(Object obj) {
        return obj instanceof SchemaCompatibilityTestingSerializer && Objects.equals(this.tokenForEqualityChecks, ((SchemaCompatibilityTestingSerializer)((Object)obj)).tokenForEqualityChecks);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.tokenForEqualityChecks);
    }

    public String toString() {
        return "SchemaCompatibilityTestingSerializer{tokenForEqualityChecks='" + this.tokenForEqualityChecks + '\'' + '}';
    }

    public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
        return new SchemaCompatibilityTestingSnapshot(this.tokenForEqualityChecks, this.resolver);
    }

    public boolean isImmutableType() {
        throw new UnsupportedOperationException();
    }

    public TypeSerializer<Integer> duplicate() {
        throw new UnsupportedOperationException();
    }

    public Integer createInstance() {
        throw new UnsupportedOperationException();
    }

    public Integer copy(Integer from) {
        throw new UnsupportedOperationException();
    }

    public Integer copy(Integer from, Integer reuse) {
        throw new UnsupportedOperationException();
    }

    public int getLength() {
        throw new UnsupportedOperationException();
    }

    public void serialize(Integer record, DataOutputView target) {
        throw new UnsupportedOperationException();
    }

    public Integer deserialize(DataInputView source) {
        throw new UnsupportedOperationException();
    }

    public Integer deserialize(Integer reuse, DataInputView source) {
        throw new UnsupportedOperationException();
    }

    public void copy(DataInputView source, DataOutputView target) {
        throw new UnsupportedOperationException();
    }

    public static final class SchemaCompatibilityTestingSnapshot
    implements TypeSerializerSnapshot<Integer> {
        @Nullable
        private final String tokenForEqualityChecks;
        private final Function<TypeSerializer<Integer>, TypeSerializerSchemaCompatibility<Integer>> resolver;

        public static SchemaCompatibilityTestingSnapshot thatIsCompatibleWithNextSerializer() {
            return SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializer(null);
        }

        public static SchemaCompatibilityTestingSnapshot thatIsCompatibleWithNextSerializer(String tokenForEqualityChecks) {
            return new SchemaCompatibilityTestingSnapshot(tokenForEqualityChecks, unused -> TypeSerializerSchemaCompatibility.compatibleAsIs());
        }

        public static SchemaCompatibilityTestingSnapshot thatIsCompatibleWithNextSerializerAfterReconfiguration() {
            return SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterReconfiguration(null);
        }

        public static SchemaCompatibilityTestingSnapshot thatIsCompatibleWithNextSerializerAfterReconfiguration(String tokenForEqualityChecks) {
            SchemaCompatibilityTestingSerializer reconfiguredSerializer = new SchemaCompatibilityTestingSerializer(tokenForEqualityChecks, ALWAYS_COMPATIBLE);
            return new SchemaCompatibilityTestingSnapshot(tokenForEqualityChecks, unused -> TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)reconfiguredSerializer));
        }

        public static SchemaCompatibilityTestingSnapshot thatIsCompatibleWithNextSerializerAfterMigration() {
            return SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithNextSerializerAfterMigration(null);
        }

        public static SchemaCompatibilityTestingSnapshot thatIsCompatibleWithNextSerializerAfterMigration(String tokenForEqualityChecks) {
            return new SchemaCompatibilityTestingSnapshot(tokenForEqualityChecks, unused -> TypeSerializerSchemaCompatibility.compatibleAfterMigration());
        }

        public static SchemaCompatibilityTestingSnapshot thatIsIncompatibleWithTheNextSerializer() {
            return SchemaCompatibilityTestingSnapshot.thatIsIncompatibleWithTheNextSerializer(null);
        }

        public static SchemaCompatibilityTestingSnapshot thatIsIncompatibleWithTheNextSerializer(String tokenForEqualityChecks) {
            return new SchemaCompatibilityTestingSnapshot(tokenForEqualityChecks, unused -> TypeSerializerSchemaCompatibility.incompatible());
        }

        SchemaCompatibilityTestingSnapshot(@Nullable String tokenForEqualityChecks, Function<TypeSerializer<Integer>, TypeSerializerSchemaCompatibility<Integer>> resolver) {
            this.tokenForEqualityChecks = tokenForEqualityChecks;
            this.resolver = resolver;
        }

        public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializer<Integer> newSerializer) {
            if (!(newSerializer instanceof SchemaCompatibilityTestingSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            SchemaCompatibilityTestingSerializer schemaCompatibilityTestingSerializer = (SchemaCompatibilityTestingSerializer)newSerializer;
            if (!Objects.equals(schemaCompatibilityTestingSerializer.tokenForEqualityChecks, this.tokenForEqualityChecks)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return this.resolver.apply(newSerializer);
        }

        public int getCurrentVersion() {
            throw new UnsupportedOperationException();
        }

        public void writeSnapshot(DataOutputView out) {
            throw new UnsupportedOperationException();
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
            throw new UnsupportedOperationException();
        }

        public TypeSerializer<Integer> restoreSerializer() {
            return new SchemaCompatibilityTestingSerializer(this.tokenForEqualityChecks, this.resolver);
        }
    }
}

