/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class CollectionUtilTest {
    @Test
    public void testPartition() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Collection partitioned = CollectionUtil.partition(list, (int)4);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)partitioned).as("List partitioned into the an incorrect number of partitions", new Object[0])).hasSize(4);
        Assertions.assertThat((Collection)partitioned).allSatisfy(partition -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)partition).hasSize(1);
        });
    }

    @Test
    public void testOfNullableWithNull() {
        Assertions.assertThat((Collection)CollectionUtil.ofNullable(null)).isEmpty();
    }

    @Test
    public void testFromNullableWithObject() {
        Object element = new Object();
        ((ObjectAssert)Assertions.assertThat((Collection)CollectionUtil.ofNullable((Object)element)).singleElement()).isEqualTo(element);
    }
}

