/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class IOUtilsTest
extends TestLogger {
    @Test
    public void testTryReadFullyFromLongerStream() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test-data".getBytes());
        byte[] out = new byte[4];
        int read = IOUtils.tryReadFully((InputStream)inputStream, (byte[])out);
        Assert.assertArrayEquals((byte[])"test".getBytes(), (byte[])Arrays.copyOfRange(out, 0, read));
    }

    @Test
    public void testTryReadFullyFromShorterStream() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("t".getBytes());
        byte[] out = new byte[4];
        int read = IOUtils.tryReadFully((InputStream)inputStream, (byte[])out);
        Assert.assertArrayEquals((byte[])"t".getBytes(), (byte[])Arrays.copyOfRange(out, 0, read));
    }
}

