/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLClassLoader;
import java.util.Objects;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleValueSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InstantiationUtilTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String PROXY_DEFINITION_FORMAT = "import java.lang.reflect.InvocationHandler;import java.lang.reflect.Method;import java.io.Serializable;public class %s implements InvocationHandler, Serializable {\n\n  @Override\n  public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {\n    return null;\n  }\n}";

    @Test
    public void testResolveProxyClass() throws Exception {
        String interfaceName = "UserDefinedInterface";
        String proxyName = "UserProxy";
        try (URLClassLoader userClassLoader = this.createClassLoader("UserDefinedInterface", "UserProxy");){
            Class<?> userInterface = Class.forName("UserDefinedInterface", false, userClassLoader);
            InvocationHandler userProxy = (InvocationHandler)Class.forName("UserProxy", false, userClassLoader).newInstance();
            Object proxy = Proxy.newProxyInstance(userClassLoader, new Class[]{userInterface}, userProxy);
            byte[] serializeObject = InstantiationUtil.serializeObject((Object)proxy);
            Object deserializedProxy = InstantiationUtil.deserializeObject((byte[])serializeObject, (ClassLoader)userClassLoader);
            Assert.assertNotNull((Object)deserializedProxy);
        }
    }

    private URLClassLoader createClassLoader(String interfaceName, String proxyName) throws IOException {
        return ClassLoaderUtils.withRoot(temporaryFolder.newFolder()).addClass(interfaceName, String.format("interface %s { void test();}", interfaceName)).addClass(proxyName, this.createProxyDefinition(proxyName)).build();
    }

    private String createProxyDefinition(String proxyName) {
        return String.format(PROXY_DEFINITION_FORMAT, proxyName);
    }

    @Test
    public void testInstantiationOfStringValue() {
        StringValue stringValue = (StringValue)InstantiationUtil.instantiate(StringValue.class, null);
        Assert.assertNotNull((Object)stringValue);
    }

    @Test
    public void testInstantiationOfStringValueAndCastToValue() {
        StringValue stringValue = (StringValue)InstantiationUtil.instantiate(StringValue.class, Value.class);
        Assert.assertNotNull((Object)stringValue);
    }

    @Test
    public void testHasNullaryConstructor() {
        Assert.assertTrue((boolean)InstantiationUtil.hasPublicNullaryConstructor(StringValue.class));
    }

    @Test
    public void testClassIsProper() {
        Assert.assertTrue((boolean)InstantiationUtil.isProperClass(StringValue.class));
    }

    @Test
    public void testClassIsNotProper() {
        Assert.assertFalse((boolean)InstantiationUtil.isProperClass(Value.class));
    }

    @Test(expected=RuntimeException.class)
    public void testCheckForInstantiationOfPrivateClass() {
        InstantiationUtil.checkForInstantiation(TestClass.class);
    }

    @Test
    public void testSerializationToByteArray() throws IOException {
        DoubleValue toSerialize = new DoubleValue(Math.random());
        DoubleValueSerializer serializer = new DoubleValueSerializer();
        byte[] serialized = InstantiationUtil.serializeToByteArray((TypeSerializer)serializer, (Object)toSerialize);
        DoubleValue deserialized = (DoubleValue)InstantiationUtil.deserializeFromByteArray((TypeSerializer)serializer, (byte[])serialized);
        Assert.assertEquals((String)"Serialized record is not equal after serialization.", (Object)toSerialize, (Object)deserialized);
    }

    @Test
    public void testCompressionAndSerializationAlongWithDecompressionAndDeserialization() throws IOException, ClassNotFoundException {
        String value = "teststring";
        Assert.assertEquals((Object)"teststring", (Object)InstantiationUtil.decompressAndDeserializeObject((byte[])InstantiationUtil.serializeObjectAndCompress((Object)"teststring"), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
    }

    @Test
    public void testWriteToConfigFailingSerialization() {
        try {
            String key1 = "testkey1";
            String key2 = "testkey2";
            Configuration config = new Configuration();
            try {
                InstantiationUtil.writeObjectToConfig((Object)new TestClassWriteFails(), (Configuration)config, (String)"irgnored");
                Assert.fail((String)"should throw an exception");
            }
            catch (TestException testException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception type - exception not properly forwarded");
            }
            InstantiationUtil.writeObjectToConfig((Object)new TestClassReadFails(), (Configuration)config, (String)"testkey1");
            InstantiationUtil.writeObjectToConfig((Object)new TestClassReadFailsCNF(), (Configuration)config, (String)"testkey2");
            try {
                InstantiationUtil.readObjectFromConfig((Configuration)config, (String)"testkey1", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                Assert.fail((String)"should throw an exception");
            }
            catch (TestException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception type - exception not properly forwarded");
            }
            try {
                InstantiationUtil.readObjectFromConfig((Configuration)config, (String)"testkey2", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                Assert.fail((String)"should throw an exception");
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"Wrong exception type - exception not properly forwarded");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCopyWritable() throws Exception {
        WritableType original = new WritableType();
        WritableType copy = (WritableType)InstantiationUtil.createCopyWritable((IOReadableWritable)original);
        Assert.assertTrue((original != copy ? 1 : 0) != 0);
        Assert.assertTrue((boolean)original.equals(copy));
    }

    public static final class WritableType
    implements IOReadableWritable {
        private int aInt;
        private long aLong;

        public WritableType() {
            Random rnd = new Random();
            this.aInt = rnd.nextInt();
            this.aLong = rnd.nextLong();
        }

        public int hashCode() {
            return Objects.hash(this.aInt, this.aLong);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == WritableType.class) {
                WritableType that = (WritableType)obj;
                return this.aLong == that.aLong && this.aInt == that.aInt;
            }
            return false;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.aInt);
            out.writeLong(this.aLong);
        }

        public void read(DataInputView in) throws IOException {
            this.aInt = in.readInt();
            this.aLong = in.readLong();
        }
    }

    private static class TestClassReadFailsCNF
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TestClassReadFailsCNF() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new ClassNotFoundException("test exception");
        }
    }

    private static class TestClassReadFails
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TestClassReadFails() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new TestException();
        }
    }

    private static class TestClassWriteFails
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TestClassWriteFails() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new TestException();
        }
    }

    private static class TestException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private TestException() {
        }
    }

    private class TestClass {
        private TestClass() {
        }
    }
}

