/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.MathUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilTest {
    @Test
    public void testLog2Computation() {
        Assert.assertEquals((long)0L, (long)MathUtils.log2floor((int)1));
        Assert.assertEquals((long)1L, (long)MathUtils.log2floor((int)2));
        Assert.assertEquals((long)1L, (long)MathUtils.log2floor((int)3));
        Assert.assertEquals((long)2L, (long)MathUtils.log2floor((int)4));
        Assert.assertEquals((long)2L, (long)MathUtils.log2floor((int)5));
        Assert.assertEquals((long)2L, (long)MathUtils.log2floor((int)7));
        Assert.assertEquals((long)3L, (long)MathUtils.log2floor((int)8));
        Assert.assertEquals((long)3L, (long)MathUtils.log2floor((int)9));
        Assert.assertEquals((long)4L, (long)MathUtils.log2floor((int)16));
        Assert.assertEquals((long)4L, (long)MathUtils.log2floor((int)17));
        Assert.assertEquals((long)13L, (long)MathUtils.log2floor((int)8193));
        Assert.assertEquals((long)30L, (long)MathUtils.log2floor((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)31L, (long)MathUtils.log2floor((int)-1));
        try {
            MathUtils.log2floor((int)0);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundDownToPowerOf2() {
        Assert.assertEquals((long)0L, (long)MathUtils.roundDownToPowerOf2((int)0));
        Assert.assertEquals((long)1L, (long)MathUtils.roundDownToPowerOf2((int)1));
        Assert.assertEquals((long)2L, (long)MathUtils.roundDownToPowerOf2((int)2));
        Assert.assertEquals((long)2L, (long)MathUtils.roundDownToPowerOf2((int)3));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)4));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)5));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)6));
        Assert.assertEquals((long)4L, (long)MathUtils.roundDownToPowerOf2((int)7));
        Assert.assertEquals((long)8L, (long)MathUtils.roundDownToPowerOf2((int)8));
        Assert.assertEquals((long)8L, (long)MathUtils.roundDownToPowerOf2((int)9));
        Assert.assertEquals((long)8L, (long)MathUtils.roundDownToPowerOf2((int)15));
        Assert.assertEquals((long)16L, (long)MathUtils.roundDownToPowerOf2((int)16));
        Assert.assertEquals((long)16L, (long)MathUtils.roundDownToPowerOf2((int)17));
        Assert.assertEquals((long)16L, (long)MathUtils.roundDownToPowerOf2((int)31));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)32));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)33));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)42));
        Assert.assertEquals((long)32L, (long)MathUtils.roundDownToPowerOf2((int)63));
        Assert.assertEquals((long)64L, (long)MathUtils.roundDownToPowerOf2((int)64));
        Assert.assertEquals((long)64L, (long)MathUtils.roundDownToPowerOf2((int)125));
        Assert.assertEquals((long)16384L, (long)MathUtils.roundDownToPowerOf2((int)25654));
        Assert.assertEquals((long)0x2000000L, (long)MathUtils.roundDownToPowerOf2((int)34366363));
        Assert.assertEquals((long)0x2000000L, (long)MathUtils.roundDownToPowerOf2((int)63463463));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundDownToPowerOf2((int)1852987883));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundDownToPowerOf2((int)Integer.MAX_VALUE));
    }

    @Test
    public void testRoundUpToPowerOf2() {
        Assert.assertEquals((long)0L, (long)MathUtils.roundUpToPowerOfTwo((int)0));
        Assert.assertEquals((long)1L, (long)MathUtils.roundUpToPowerOfTwo((int)1));
        Assert.assertEquals((long)2L, (long)MathUtils.roundUpToPowerOfTwo((int)2));
        Assert.assertEquals((long)4L, (long)MathUtils.roundUpToPowerOfTwo((int)3));
        Assert.assertEquals((long)4L, (long)MathUtils.roundUpToPowerOfTwo((int)4));
        Assert.assertEquals((long)8L, (long)MathUtils.roundUpToPowerOfTwo((int)5));
        Assert.assertEquals((long)8L, (long)MathUtils.roundUpToPowerOfTwo((int)6));
        Assert.assertEquals((long)8L, (long)MathUtils.roundUpToPowerOfTwo((int)7));
        Assert.assertEquals((long)8L, (long)MathUtils.roundUpToPowerOfTwo((int)8));
        Assert.assertEquals((long)16L, (long)MathUtils.roundUpToPowerOfTwo((int)9));
        Assert.assertEquals((long)16L, (long)MathUtils.roundUpToPowerOfTwo((int)15));
        Assert.assertEquals((long)16L, (long)MathUtils.roundUpToPowerOfTwo((int)16));
        Assert.assertEquals((long)32L, (long)MathUtils.roundUpToPowerOfTwo((int)17));
        Assert.assertEquals((long)32L, (long)MathUtils.roundUpToPowerOfTwo((int)31));
        Assert.assertEquals((long)32L, (long)MathUtils.roundUpToPowerOfTwo((int)32));
        Assert.assertEquals((long)64L, (long)MathUtils.roundUpToPowerOfTwo((int)33));
        Assert.assertEquals((long)64L, (long)MathUtils.roundUpToPowerOfTwo((int)42));
        Assert.assertEquals((long)64L, (long)MathUtils.roundUpToPowerOfTwo((int)63));
        Assert.assertEquals((long)64L, (long)MathUtils.roundUpToPowerOfTwo((int)64));
        Assert.assertEquals((long)128L, (long)MathUtils.roundUpToPowerOfTwo((int)125));
        Assert.assertEquals((long)32768L, (long)MathUtils.roundUpToPowerOfTwo((int)25654));
        Assert.assertEquals((long)0x4000000L, (long)MathUtils.roundUpToPowerOfTwo((int)34366363));
        Assert.assertEquals((long)0x4000000L, (long)MathUtils.roundUpToPowerOfTwo((int)0x3FFFFFF));
        Assert.assertEquals((long)0x4000000L, (long)MathUtils.roundUpToPowerOfTwo((int)0x4000000));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundUpToPowerOfTwo((int)0x3FFFFFFE));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundUpToPowerOfTwo((int)0x3FFFFFFF));
        Assert.assertEquals((long)0x40000000L, (long)MathUtils.roundUpToPowerOfTwo((int)0x40000000));
    }

    @Test
    public void testPowerOfTwo() {
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)1L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)2L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)4L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)8L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)32768L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)65536L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x40000000L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x80000000L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x20000000000L));
        Assert.assertTrue((boolean)MathUtils.isPowerOf2((long)0x4000000000000000L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)3L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)5L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)567923L));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)MathUtils.isPowerOf2((long)Long.MAX_VALUE));
    }

    @Test
    public void testFlipSignBit() {
        Assert.assertEquals((long)0L, (long)MathUtils.flipSignBit((long)Long.MIN_VALUE));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)MathUtils.flipSignBit((long)0L));
        Assert.assertEquals((long)-1L, (long)MathUtils.flipSignBit((long)Long.MAX_VALUE));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)MathUtils.flipSignBit((long)-1L));
        Assert.assertEquals((long)-9223372036854775766L, (long)MathUtils.flipSignBit((long)42L));
        Assert.assertEquals((long)9223372036854775766L, (long)MathUtils.flipSignBit((long)-42L));
    }

    @Test
    public void testDivideRoundUp() {
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)0, (int)1), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)0, (int)2), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)1, (int)1), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)1, (int)2), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)2, (int)1), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)2, (int)2), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)MathUtils.divideRoundUp((int)2, (int)3), (Matcher)Matchers.is((Object)1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideRoundUpNegativeDividend() {
        MathUtils.divideRoundUp((int)-1, (int)1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideRoundUpNegativeDivisor() {
        MathUtils.divideRoundUp((int)1, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideRoundUpZeroDivisor() {
        MathUtils.divideRoundUp((int)1, (int)0);
    }
}

