/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.jackson;

import java.time.Instant;
import java.util.Optional;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvParser;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JacksonMapperFactoryTest {
    JacksonMapperFactoryTest() {
    }

    @Test
    void testCreateObjectMapperReturnDistinctMappers() {
        ObjectMapper mapper1 = JacksonMapperFactory.createObjectMapper();
        ObjectMapper mapper2 = JacksonMapperFactory.createObjectMapper();
        Assertions.assertThat((Object)mapper1).isNotSameAs((Object)mapper2);
    }

    @Test
    void testCreateCsvMapperReturnDistinctMappers() {
        CsvMapper mapper1 = JacksonMapperFactory.createCsvMapper();
        CsvMapper mapper2 = JacksonMapperFactory.createCsvMapper();
        Assertions.assertThat((Object)mapper1).isNotSameAs((Object)mapper2);
    }

    @Test
    void testObjectMapperOptionalSupportedEnabled() throws Exception {
        ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();
        Assertions.assertThat((String)mapper.writeValueAsString((Object)new TypeWithOptional(Optional.of("value")))).isEqualTo("{\"data\":\"value\"}");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)new TypeWithOptional(Optional.empty()))).isEqualTo("{\"data\":null}");
        Assertions.assertThat(((TypeWithOptional)mapper.readValue((String)"{\"data\":\"value\"}", TypeWithOptional.class)).data).contains((Object)"value");
        Assertions.assertThat(((TypeWithOptional)mapper.readValue((String)"{\"data\":null}", TypeWithOptional.class)).data).isEmpty();
        Assertions.assertThat(((TypeWithOptional)mapper.readValue((String)"{}", TypeWithOptional.class)).data).isEmpty();
    }

    @Test
    void testCsvMapperOptionalSupportedEnabled() throws Exception {
        CsvMapper mapper = JacksonMapperFactory.createCsvMapper().enable(CsvParser.Feature.EMPTY_STRING_AS_NULL);
        ObjectWriter writer = mapper.writerWithSchemaFor(TypeWithOptional.class);
        Assertions.assertThat((String)writer.writeValueAsString((Object)new TypeWithOptional(Optional.of("value")))).isEqualTo("value\n");
        Assertions.assertThat((String)writer.writeValueAsString((Object)new TypeWithOptional(Optional.empty()))).isEqualTo("\n");
        ObjectReader reader = mapper.readerWithSchemaFor(TypeWithOptional.class);
        Assertions.assertThat(((TypeWithOptional)reader.readValue((String)"value\n", TypeWithOptional.class)).data).contains((Object)"value");
        Assertions.assertThat(((TypeWithOptional)reader.readValue((String)"null\n", TypeWithOptional.class)).data).contains((Object)"null");
        Assertions.assertThat(((TypeWithOptional)reader.readValue((String)"\n", TypeWithOptional.class)).data).isEmpty();
    }

    @Test
    void testObjectMappeDateTimeSupportedEnabled() throws Exception {
        ObjectMapper mapper = JacksonMapperFactory.createObjectMapper();
        String instantString = "2022-08-07T12:00:33.107787800Z";
        Instant instant = Instant.parse("2022-08-07T12:00:33.107787800Z");
        String instantJson = String.format("{\"data\":\"%s\"}", "2022-08-07T12:00:33.107787800Z");
        Assertions.assertThat((String)mapper.writeValueAsString((Object)new TypeWithInstant(instant))).isEqualTo(instantJson);
        Assertions.assertThat((Instant)((TypeWithInstant)mapper.readValue((String)instantJson, TypeWithInstant.class)).data).isEqualTo((Object)instant);
    }

    @Test
    void testCsvMapperDateTimeSupportedEnabled() throws Exception {
        CsvMapper mapper = JacksonMapperFactory.createCsvMapper();
        String instantString = "2022-08-07T12:00:33.107787800Z";
        Instant instant = Instant.parse("2022-08-07T12:00:33.107787800Z");
        String instantCsv = String.format("\"%s\"\n", "2022-08-07T12:00:33.107787800Z");
        ObjectWriter writer = mapper.writerWithSchemaFor(TypeWithInstant.class);
        Assertions.assertThat((String)writer.writeValueAsString((Object)new TypeWithInstant(instant))).isEqualTo(instantCsv);
        ObjectReader reader = mapper.readerWithSchemaFor(TypeWithInstant.class);
        Assertions.assertThat((Instant)((TypeWithInstant)reader.readValue((String)instantCsv, TypeWithInstant.class)).data).isEqualTo((Object)instant);
    }

    public static class TypeWithInstant {
        public Instant data;

        @JsonCreator
        public TypeWithInstant(@JsonProperty(value="data") Instant data) {
            this.data = data;
        }
    }

    public static class TypeWithOptional {
        public Optional<String> data;

        @JsonCreator
        public TypeWithOptional(@JsonProperty(value="data") Optional<String> data) {
            this.data = data;
        }
    }
}

