/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.util.ratelimit;

import java.io.Serializable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.connector.source.util.ratelimit.GatedRateLimiter;
import org.apache.flink.api.connector.source.util.ratelimit.GuavaRateLimiter;
import org.apache.flink.api.connector.source.util.ratelimit.NoOpRateLimiter;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiter;
import org.apache.flink.util.Preconditions;

@Experimental
public interface RateLimiterStrategy
extends Serializable {
    public RateLimiter createRateLimiter(int var1);

    public static RateLimiterStrategy perSecond(double recordsPerSecond) {
        return parallelism -> new GuavaRateLimiter(recordsPerSecond / (double)parallelism);
    }

    public static RateLimiterStrategy perCheckpoint(int recordsPerCheckpoint) {
        return parallelism -> {
            int recordsPerSubtask = recordsPerCheckpoint / parallelism;
            Preconditions.checkArgument(recordsPerSubtask > 0, "recordsPerCheckpoint has to be greater or equal to parallelism. Either decrease the parallelism or increase the number of recordsPerCheckpoint.");
            return new GatedRateLimiter(recordsPerSubtask);
        };
    }

    public static RateLimiterStrategy noOp() {
        return parallelism -> new NoOpRateLimiter();
    }
}

