/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.LongMaximum;
import org.junit.Assert;
import org.junit.Test;

public class LongMaximumTest {
    @Test
    public void testGet() {
        LongMaximum max = new LongMaximum();
        Assert.assertEquals((long)Long.MIN_VALUE, (long)max.getLocalValue());
    }

    @Test
    public void testResetLocal() {
        LongMaximum max = new LongMaximum();
        long value = 9876543210L;
        max.add(value);
        Assert.assertEquals((long)value, (long)max.getLocalValue());
        max.resetLocal();
        Assert.assertEquals((long)Long.MIN_VALUE, (long)max.getLocalValue());
    }

    @Test
    public void testAdd() {
        LongMaximum max = new LongMaximum();
        max.add(1234567890L);
        max.add(9876543210L);
        max.add(-9876543210L);
        max.add(-1234567890L);
        Assert.assertEquals((long)9876543210L, (long)max.getLocalValue());
    }

    @Test
    public void testMerge() {
        LongMaximum max1 = new LongMaximum();
        max1.add(1234567890987654321L);
        LongMaximum max2 = new LongMaximum();
        max2.add(5678909876543210123L);
        max2.merge((Accumulator)max1);
        Assert.assertEquals((long)5678909876543210123L, (long)max2.getLocalValue());
        max1.merge((Accumulator)max2);
        Assert.assertEquals((long)5678909876543210123L, (long)max1.getLocalValue());
    }

    @Test
    public void testClone() {
        LongMaximum max = new LongMaximum();
        long value = 4242424242424242L;
        max.add(value);
        LongMaximum clone = max.clone();
        Assert.assertEquals((long)value, (long)clone.getLocalValue());
    }
}

