/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.resources;

import java.math.BigDecimal;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.api.common.resources.TestResource;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ResourceTest
extends TestLogger {
    @Test
    public void testConstructorValid() {
        TestResource v1 = new TestResource(0.1);
        ResourceTest.assertTestResourceValueEquals(0.1, v1);
        TestResource v2 = new TestResource(BigDecimal.valueOf(0.1));
        ResourceTest.assertTestResourceValueEquals(0.1, v2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorInvalidValue() {
        new TestResource(-0.1);
    }

    @Test
    public void testEquals() {
        TestResource v1 = new TestResource(0.1);
        TestResource v2 = new TestResource(0.1);
        TestResource v3 = new TestResource(0.2);
        Assert.assertTrue((boolean)v1.equals((Object)v2));
        Assert.assertFalse((boolean)v1.equals((Object)v3));
    }

    @Test
    public void testEqualsIgnoringScale() {
        TestResource v1 = new TestResource(new BigDecimal("0.1"));
        TestResource v2 = new TestResource(new BigDecimal("0.10"));
        Assert.assertTrue((boolean)v1.equals((Object)v2));
    }

    @Test
    public void testHashCodeIgnoringScale() {
        TestResource v1 = new TestResource(new BigDecimal("0.1"));
        TestResource v2 = new TestResource(new BigDecimal("0.10"));
        Assert.assertTrue((v1.hashCode() == v2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testMerge() {
        TestResource v1 = new TestResource(0.1);
        TestResource v2 = new TestResource(0.2);
        ResourceTest.assertTestResourceValueEquals(0.3, v1.merge(v2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMergeErrorOnDifferentTypes() {
        TestResource v1 = new TestResource(0.1);
        CPUResource v2 = new CPUResource(0.1);
        v1.merge((Resource)v2);
    }

    @Test
    public void testSubtract() {
        TestResource v1 = new TestResource(0.2);
        TestResource v2 = new TestResource(0.1);
        ResourceTest.assertTestResourceValueEquals(0.1, v1.subtract(v2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubtractLargerValue() {
        TestResource v1 = new TestResource(0.1);
        TestResource v2 = new TestResource(0.2);
        v1.subtract(v2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubtractErrorOnDifferentTypes() {
        TestResource v1 = new TestResource(0.1);
        CPUResource v2 = new CPUResource(0.1);
        v1.subtract((Resource)v2);
    }

    @Test
    public void testDivide() {
        TestResource resource = new TestResource(0.04);
        BigDecimal by = BigDecimal.valueOf(0.1);
        ResourceTest.assertTestResourceValueEquals(0.4, resource.divide(by));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideNegative() {
        TestResource resource = new TestResource(1.2);
        BigDecimal by = BigDecimal.valueOf(-0.5);
        resource.divide(by);
    }

    @Test
    public void testDivideInteger() {
        TestResource resource = new TestResource(0.12);
        int by = 4;
        ResourceTest.assertTestResourceValueEquals(0.03, resource.divide(4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideNegativeInteger() {
        TestResource resource = new TestResource(1.2);
        int by = -5;
        resource.divide(-5);
    }

    @Test
    public void testMultiply() {
        TestResource resource = new TestResource(0.3);
        BigDecimal by = BigDecimal.valueOf(0.2);
        ResourceTest.assertTestResourceValueEquals(0.06, resource.multiply(by));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMutiplyNegative() {
        TestResource resource = new TestResource(0.3);
        BigDecimal by = BigDecimal.valueOf(-0.2);
        resource.multiply(by);
    }

    @Test
    public void testMultiplyInteger() {
        TestResource resource = new TestResource(0.3);
        int by = 2;
        ResourceTest.assertTestResourceValueEquals(0.6, resource.multiply(2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMutiplyNegativeInteger() {
        TestResource resource = new TestResource(0.3);
        int by = -2;
        resource.multiply(-2);
    }

    @Test
    public void testIsZero() {
        TestResource resource1 = new TestResource(0.0);
        TestResource resource2 = new TestResource(1.0);
        Assert.assertTrue((boolean)resource1.isZero());
        Assert.assertFalse((boolean)resource2.isZero());
    }

    @Test
    public void testCompareTo() {
        TestResource resource1 = new TestResource(0.0);
        TestResource resource2 = new TestResource(0.0);
        TestResource resource3 = new TestResource(1.0);
        Assert.assertThat((Object)resource1.compareTo(resource1), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)resource1.compareTo(resource2), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)resource1.compareTo(resource3), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)resource3.compareTo(resource1), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompareToFailNull() {
        new TestResource(0.0).compareTo(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompareToFailDifferentType() {
        TestResource resource1 = new TestResource(0.0){};
        TestResource resource2 = new TestResource(0.0){};
        resource1.compareTo(resource2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCompareToFailDifferentName() {
        TestResource resource1 = new TestResource("name1", 0.0);
        TestResource resource2 = new TestResource("name2", 0.0);
        resource1.compareTo(resource2);
    }

    @Test
    public void testValueScaleLimited() {
        TestResource v1 = new TestResource(0.100000001);
        ResourceTest.assertTestResourceValueEquals(0.1, v1);
        Resource v2 = new TestResource(1.0).divide(3);
        ResourceTest.assertTestResourceValueEquals(0.33333333, v2);
    }

    @Test
    public void testStripTrailingZeros() {
        Resource v = new TestResource(0.25).multiply(2);
        Assert.assertThat((Object)v.getValue().toString(), (Matcher)Matchers.is((Object)"0.5"));
    }

    private static void assertTestResourceValueEquals(double value, Resource resource) {
        Assert.assertEquals((Object)((Object)new TestResource(value)), (Object)resource);
    }
}

