/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.ClassRelocator;
import org.apache.flink.api.common.typeutils.ThreadContextClassLoader;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.test.util.MigrationTest;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class TypeSerializerUpgradeTestBase<PreviousElementT, UpgradedElementT>
implements MigrationTest {
    private static final int INITIAL_OUTPUT_BUFFER_SIZE = 64;

    public abstract Collection<TestSpecification<?, ?>> createTestSpecifications(FlinkVersion var1) throws Exception;

    public Collection<FlinkVersion> getMigrationVersions() {
        return FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v1_11, (FlinkVersion)MigrationTest.getMostRecentlyPublishedVersion());
    }

    public final Collection<TestSpecification<?, ?>> createTestSpecificationsForAllVersions() throws Exception {
        ArrayList specificationList = new ArrayList();
        for (FlinkVersion version : this.getMigrationVersions()) {
            specificationList.addAll(this.createTestSpecifications(version));
        }
        return specificationList;
    }

    @MigrationTest.ParameterizedSnapshotsGenerator(value="createTestSpecifications")
    public void generateTestSetupFiles(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        Files.createDirectories(this.getSerializerSnapshotFilePath(testSpecification).getParent(), new FileAttribute[0]);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)testSpecification).setup.setupClassloader);){
            TypeSerializer priorSerializer = ((TestSpecification)testSpecification).setup.createPriorSerializer();
            DataOutputSerializer testDataOut = new DataOutputSerializer(64);
            priorSerializer.serialize(((TestSpecification)testSpecification).setup.createTestData(), (DataOutputView)testDataOut);
            TypeSerializerUpgradeTestBase.writeContentsTo(this.getGenerateDataFilePath(testSpecification), testDataOut.getCopyOfBuffer());
            DataOutputSerializer serializerSnapshotOut = new DataOutputSerializer(64);
            TypeSerializerUpgradeTestBase.writeSerializerSnapshot((DataOutputView)serializerSnapshotOut, priorSerializer, ((TestSpecification)testSpecification).flinkVersion);
            TypeSerializerUpgradeTestBase.writeContentsTo(this.getGenerateSerializerSnapshotFilePath(testSpecification), serializerSnapshotOut.getCopyOfBuffer());
        }
    }

    @ParameterizedTest(name="Test Specification = {0}")
    @MethodSource(value={"createTestSpecificationsForAllVersions"})
    void restoreSerializerIsValid(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)testSpecification).verifier.verifierClassloader);){
            ((ObjectAssert)Assumptions.assumeThat((Object)TypeSerializerSchemaCompatibility.incompatible()).as("This test only applies for test specifications that verify an upgraded serializer that is not incompatible.", new Object[0])).is((Condition)HamcrestCondition.matching((Matcher)CoreMatchers.not(((TestSpecification)testSpecification).verifier.schemaCompatibilityMatcher(((TestSpecification)testSpecification).flinkVersion))));
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest(testSpecification);
            TypeSerializer restoredSerializer = restoredSerializerSnapshot.restoreSerializer();
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(restoredSerializer, this.dataUnderTest(testSpecification), ((TestSpecification)testSpecification).verifier.testDataMatcher());
        }
    }

    @ParameterizedTest(name="Test Specification = {0}")
    @MethodSource(value={"createTestSpecificationsForAllVersions"})
    void upgradedSerializerHasExpectedSchemaCompatibility(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest(testSpecification);
            TypeSerializer upgradedSerializer = ((TestSpecification)testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            AssertionsForInterfaceTypes.assertThat((Object)upgradeCompatibility).is((Condition)HamcrestCondition.matching(((TestSpecification)testSpecification).verifier.schemaCompatibilityMatcher(((TestSpecification)testSpecification).flinkVersion)));
        }
    }

    @ParameterizedTest(name="Test Specification = {0}")
    @MethodSource(value={"createTestSpecificationsForAllVersions"})
    void upgradedSerializerIsValidAfterMigration(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest(testSpecification);
            TypeSerializer upgradedSerializer = ((TestSpecification)testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            ((ObjectAssert)Assumptions.assumeThat((Object)upgradeCompatibility).as("This test only applies for test specifications that verify an upgraded serializer that requires migration to be compatible.", new Object[0])).is((Condition)HamcrestCondition.matching(TypeSerializerMatchers.isCompatibleAfterMigration()));
            TypeSerializer restoreSerializer = restoredSerializerSnapshot.restoreSerializer();
            DataInputView migratedData = TypeSerializerUpgradeTestBase.readAndThenWriteData(this.dataUnderTest(testSpecification), restoreSerializer, upgradedSerializer, ((TestSpecification)testSpecification).verifier.testDataMatcher());
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(upgradedSerializer, migratedData, ((TestSpecification)testSpecification).verifier.testDataMatcher());
        }
    }

    @ParameterizedTest(name="Test Specification = {0}")
    @MethodSource(value={"createTestSpecificationsForAllVersions"})
    void upgradedSerializerIsValidAfterReconfiguration(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest(testSpecification);
            TypeSerializer upgradedSerializer = ((TestSpecification)testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            ((ObjectAssert)Assumptions.assumeThat((Object)upgradeCompatibility).as("This test only applies for test specifications that verify an upgraded serializer that requires reconfiguration to be compatible.", new Object[0])).is((Condition)HamcrestCondition.matching(TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer()));
            TypeSerializer reconfiguredUpgradedSerializer = upgradeCompatibility.getReconfiguredSerializer();
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(reconfiguredUpgradedSerializer, this.dataUnderTest(testSpecification), ((TestSpecification)testSpecification).verifier.testDataMatcher());
        }
    }

    @ParameterizedTest(name="Test Specification = {0}")
    @MethodSource(value={"createTestSpecificationsForAllVersions"})
    void upgradedSerializerIsValidWhenCompatibleAsIs(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(((TestSpecification)testSpecification).verifier.verifierClassloader);){
            TypeSerializerSnapshot<UpgradedElementT> restoredSerializerSnapshot = this.snapshotUnderTest(testSpecification);
            TypeSerializer upgradedSerializer = ((TestSpecification)testSpecification).verifier.createUpgradedSerializer();
            TypeSerializerSchemaCompatibility upgradeCompatibility = restoredSerializerSnapshot.resolveSchemaCompatibility(upgradedSerializer);
            ((ObjectAssert)Assumptions.assumeThat((Object)upgradeCompatibility).as("This test only applies for test specifications that verify an upgraded serializer that is compatible as is.", new Object[0])).is((Condition)HamcrestCondition.matching(TypeSerializerMatchers.isCompatibleAsIs()));
            TypeSerializerUpgradeTestBase.assertSerializerIsValid(upgradedSerializer, this.dataUnderTest(testSpecification), ((TestSpecification)testSpecification).verifier.testDataMatcher());
        }
    }

    private static <T> void assertSerializerIsValid(TypeSerializer<T> serializer, DataInputView dataInput, Matcher<T> testDataMatcher) throws Exception {
        DataInputView serializedData = TypeSerializerUpgradeTestBase.readAndThenWriteData(dataInput, serializer, serializer, testDataMatcher);
        TypeSerializerSnapshot<T> snapshot = TypeSerializerUpgradeTestBase.writeAndThenReadSerializerSnapshot(serializer);
        TypeSerializer restoreSerializer = snapshot.restoreSerializer();
        serializedData = TypeSerializerUpgradeTestBase.readAndThenWriteData(serializedData, restoreSerializer, restoreSerializer, testDataMatcher);
        TypeSerializer duplicateSerializer = snapshot.restoreSerializer().duplicate();
        TypeSerializerUpgradeTestBase.readAndThenWriteData(serializedData, duplicateSerializer, duplicateSerializer, testDataMatcher);
    }

    private Path getGenerateSerializerSnapshotFilePath(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return Paths.get(this.getGenerateResourceDirectory(testSpecification) + "/serializer-snapshot", new String[0]);
    }

    private Path getGenerateDataFilePath(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return Paths.get(this.getGenerateResourceDirectory(testSpecification) + "/test-data", new String[0]);
    }

    private String getGenerateResourceDirectory(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return System.getProperty("user.dir") + "/src/test/resources/" + ((TestSpecification)testSpecification).name + "-" + ((TestSpecification)testSpecification).flinkVersion;
    }

    private Path getSerializerSnapshotFilePath(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return Paths.get(this.getTestResourceDirectory(testSpecification) + "/serializer-snapshot", new String[0]);
    }

    private Path getTestDataFilePath(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return Paths.get(this.getTestResourceDirectory(testSpecification) + "/test-data", new String[0]);
    }

    private String getTestResourceDirectory(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return System.getProperty("user.dir") + "/src/test/resources/" + ((TestSpecification)testSpecification).name + "-" + ((TestSpecification)testSpecification).flinkVersion;
    }

    private TypeSerializerSnapshot<UpgradedElementT> snapshotUnderTest(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) throws Exception {
        return TypeSerializerUpgradeTestBase.readSerializerSnapshot(TypeSerializerUpgradeTestBase.contentsOf(this.getSerializerSnapshotFilePath(testSpecification)), ((TestSpecification)testSpecification).flinkVersion);
    }

    private DataInputView dataUnderTest(TestSpecification<PreviousElementT, UpgradedElementT> testSpecification) {
        return TypeSerializerUpgradeTestBase.contentsOf(this.getTestDataFilePath(testSpecification));
    }

    private static void writeContentsTo(Path path, byte[] bytes) {
        try {
            Files.write(path, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to " + path, e);
        }
    }

    private static DataInputView contentsOf(Path path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new DataInputDeserializer(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read contents of " + path, e);
        }
    }

    private static <T> void writeSerializerSnapshot(DataOutputView out, TypeSerializer<T> serializer, FlinkVersion flinkVersion) throws IOException {
        if (!flinkVersion.isNewerVersionThan(FlinkVersion.v1_6)) {
            throw new UnsupportedOperationException("There should be no longer a need to support/use this path since Flink 1.17");
        }
        TypeSerializerUpgradeTestBase.writeSerializerSnapshotCurrentFormat(out, serializer);
    }

    private static <T> void writeSerializerSnapshotCurrentFormat(DataOutputView out, TypeSerializer<T> serializer) throws IOException {
        TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)out, (TypeSerializerSnapshot)serializer.snapshotConfiguration());
    }

    private static <T> TypeSerializerSnapshot<T> readSerializerSnapshot(DataInputView in, FlinkVersion flinkVersion) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Preconditions.checkState((boolean)flinkVersion.isNewerVersionThan(FlinkVersion.v1_6));
        return TypeSerializerUpgradeTestBase.readSerializerSnapshotCurrentFormat(in, classLoader);
    }

    private static <T> TypeSerializerSnapshot<T> readSerializerSnapshotCurrentFormat(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }

    private static <T> DataInputView readAndThenWriteData(DataInputView originalDataInput, TypeSerializer<T> readSerializer, TypeSerializer<T> writeSerializer, Matcher<T> testDataMatcher) throws IOException {
        Object data = readSerializer.deserialize(originalDataInput);
        AssertionsForInterfaceTypes.assertThat((Object)data).is((Condition)HamcrestCondition.matching(testDataMatcher));
        DataOutputSerializer out = new DataOutputSerializer(64);
        writeSerializer.serialize(data, (DataOutputView)out);
        return new DataInputDeserializer(out.wrapAsByteBuffer());
    }

    private static <T> TypeSerializerSnapshot<T> writeAndThenReadSerializerSnapshot(TypeSerializer<T> serializer) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(64);
        TypeSerializerUpgradeTestBase.writeSerializerSnapshotCurrentFormat((DataOutputView)out, serializer);
        DataInputDeserializer in = new DataInputDeserializer(out.wrapAsByteBuffer());
        return TypeSerializerUpgradeTestBase.readSerializerSnapshotCurrentFormat((DataInputView)in, Thread.currentThread().getContextClassLoader());
    }

    public static class TestSpecification<PreviousElementT, UpgradedElementT> {
        private final String name;
        private final FlinkVersion flinkVersion;
        private final ClassLoaderSafePreUpgradeSetup<PreviousElementT> setup;
        private final ClassLoaderSafeUpgradeVerifier<UpgradedElementT> verifier;

        public TestSpecification(String name, FlinkVersion flinkVersion, Class<? extends PreUpgradeSetup<PreviousElementT>> setupClass, Class<? extends UpgradeVerifier<UpgradedElementT>> verifierClass) throws Exception {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.flinkVersion = (FlinkVersion)Preconditions.checkNotNull((Object)flinkVersion);
            this.setup = new ClassLoaderSafePreUpgradeSetup(setupClass);
            this.verifier = new ClassLoaderSafeUpgradeVerifier(verifierClass);
        }

        public String toString() {
            return this.name + " / " + this.flinkVersion;
        }
    }

    private static class ClassLoaderSafeUpgradeVerifier<UpgradedElementT>
    implements UpgradeVerifier<UpgradedElementT> {
        private final UpgradeVerifier<UpgradedElementT> delegateVerifier;
        private final ClassLoader verifierClassloader;

        ClassLoaderSafeUpgradeVerifier(Class<? extends UpgradeVerifier<UpgradedElementT>> delegateVerifierClass) throws Exception {
            Preconditions.checkNotNull(delegateVerifierClass);
            Class relocatedDelegateVerifierClass = ClassRelocator.relocate(delegateVerifierClass);
            this.verifierClassloader = relocatedDelegateVerifierClass.getClassLoader();
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                this.delegateVerifier = (UpgradeVerifier)relocatedDelegateVerifierClass.newInstance();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public TypeSerializer<UpgradedElementT> createUpgradedSerializer() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                TypeSerializer<UpgradedElementT> typeSerializer = this.delegateVerifier.createUpgradedSerializer();
                return typeSerializer;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating upgraded serializer via ClassLoaderSafeUpgradeVerifier.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Matcher<UpgradedElementT> testDataMatcher() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                Matcher<UpgradedElementT> matcher = this.delegateVerifier.testDataMatcher();
                return matcher;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating expected test data via ClassLoaderSafeUpgradeVerifier.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Matcher<TypeSerializerSchemaCompatibility<UpgradedElementT>> schemaCompatibilityMatcher(FlinkVersion version) {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.verifierClassloader);){
                Matcher<TypeSerializerSchemaCompatibility<UpgradedElementT>> matcher = this.delegateVerifier.schemaCompatibilityMatcher(version);
                return matcher;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating schema compatibility matcher via ClassLoaderSafeUpgradeVerifier.", e);
            }
        }
    }

    private static class ClassLoaderSafePreUpgradeSetup<PreviousElementT>
    implements PreUpgradeSetup<PreviousElementT> {
        private final PreUpgradeSetup<PreviousElementT> delegateSetup;
        private final ClassLoader setupClassloader;

        ClassLoaderSafePreUpgradeSetup(Class<? extends PreUpgradeSetup<PreviousElementT>> delegateSetupClass) throws Exception {
            Preconditions.checkNotNull(delegateSetupClass);
            Class relocatedDelegateSetupClass = ClassRelocator.relocate(delegateSetupClass);
            this.setupClassloader = relocatedDelegateSetupClass.getClassLoader();
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.setupClassloader);){
                this.delegateSetup = (PreUpgradeSetup)relocatedDelegateSetupClass.newInstance();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public TypeSerializer<PreviousElementT> createPriorSerializer() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.setupClassloader);){
                TypeSerializer<PreviousElementT> typeSerializer = this.delegateSetup.createPriorSerializer();
                return typeSerializer;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating prior serializer via ClassLoaderSafePreUpgradeSetup.", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public PreviousElementT createTestData() {
            try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.setupClassloader);){
                PreviousElementT PreviousElementT = this.delegateSetup.createTestData();
                return PreviousElementT;
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating test data via ThreadContextClassLoader.", e);
            }
        }
    }

    public static interface UpgradeVerifier<UpgradedElementT> {
        public TypeSerializer<UpgradedElementT> createUpgradedSerializer();

        public Matcher<UpgradedElementT> testDataMatcher();

        public Matcher<TypeSerializerSchemaCompatibility<UpgradedElementT>> schemaCompatibilityMatcher(FlinkVersion var1);
    }

    public static interface PreUpgradeSetup<PreviousElementT> {
        public TypeSerializer<PreviousElementT> createPriorSerializer();

        public PreviousElementT createTestData();
    }
}

