/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EnumSerializerCompatibilityTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String ENUM_NAME = "EnumSerializerUpgradeTestEnum";
    private static final String ENUM_A = "public enum EnumSerializerUpgradeTestEnum { A, B, C }";
    private static final String ENUM_B = "public enum EnumSerializerUpgradeTestEnum { A, B, C, D }";
    private static final String ENUM_C = "public enum EnumSerializerUpgradeTestEnum { A, C }";
    private static final String ENUM_D = "public enum EnumSerializerUpgradeTestEnum { A, C, B }";

    @Test
    public void checkIndenticalEnums() throws Exception {
        Assert.assertTrue((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_A).isCompatibleAsIs());
    }

    @Test
    public void checkAppendedField() throws Exception {
        Assert.assertTrue((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_B).isCompatibleWithReconfiguredSerializer());
    }

    @Test(expected=IllegalStateException.class)
    public void removingFieldShouldBeIncompatible() throws Exception {
        Assert.assertTrue((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_C).isIncompatible());
    }

    @Test
    public void checkDifferentFieldOrder() throws Exception {
        Assert.assertTrue((boolean)EnumSerializerCompatibilityTest.checkCompatibility(ENUM_A, ENUM_D).isCompatibleWithReconfiguredSerializer());
    }

    private static TypeSerializerSchemaCompatibility checkCompatibility(String enumSourceA, String enumSourceB) throws IOException, ClassNotFoundException {
        TypeSerializerSnapshot restoredSnapshot;
        byte[] snapshotBytes;
        Throwable throwable;
        URLClassLoader classLoader = ClassLoaderUtils.compileAndLoadJava(temporaryFolder.newFolder(), "EnumSerializerUpgradeTestEnum.java", enumSourceA);
        EnumSerializer enumSerializer = new EnumSerializer(classLoader.loadClass(ENUM_NAME));
        EnumSerializer.EnumSerializerSnapshot snapshot = enumSerializer.snapshotConfiguration();
        try (ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();){
            throwable = null;
            try (DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper((OutputStream)outBuffer);){
                TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)outputViewStreamWrapper, (TypeSerializerSnapshot)snapshot);
                snapshotBytes = outBuffer.toByteArray();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        URLClassLoader classLoader2 = ClassLoaderUtils.compileAndLoadJava(temporaryFolder.newFolder(), "EnumSerializerUpgradeTestEnum.java", enumSourceB);
        throwable = null;
        try (ByteArrayInputStream inBuffer = new ByteArrayInputStream(snapshotBytes);
             DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inBuffer);){
            restoredSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)inputViewStreamWrapper, (ClassLoader)classLoader2);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        EnumSerializer enumSerializer2 = new EnumSerializer(classLoader2.loadClass(ENUM_NAME));
        return restoredSnapshot.resolveSchemaCompatibility((TypeSerializer)enumSerializer2);
    }
}

