/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationTest
extends TestLogger {
    private static final ConfigOption<String> STRING_OPTION = ConfigOptions.key((String)"test-string-key").stringType().noDefaultValue();
    private static final ConfigOption<List<String>> LIST_STRING_OPTION = ConfigOptions.key((String)"test-list-key").stringType().asList().noDefaultValue();
    private static final ConfigOption<Map<String, String>> MAP_OPTION = ConfigOptions.key((String)"test-map-key").mapType().noDefaultValue();
    private static final ConfigOption<Duration> DURATION_OPTION = ConfigOptions.key((String)"test-duration-key").durationType().noDefaultValue();
    private static final Map<String, String> PROPERTIES_MAP = new HashMap<String, String>();
    private static final String MAP_PROPERTY_1;
    private static final String MAP_PROPERTY_2;

    @Test
    public void testConfigurationSerializationAndGetters() {
        try {
            Configuration orig = new Configuration();
            orig.setString("mykey", "myvalue");
            orig.setInteger("mynumber", 100);
            orig.setLong("longvalue", 478236947162389746L);
            orig.setFloat("PI", 3.1415925f);
            orig.setDouble("E", Math.E);
            orig.setBoolean("shouldbetrue", true);
            orig.setBytes("bytes sequence", new byte[]{1, 2, 3, 4, 5});
            orig.setClass("myclass", ((Object)((Object)this)).getClass());
            Configuration copy = (Configuration)InstantiationUtil.createCopyWritable((IOReadableWritable)orig);
            Assert.assertEquals((Object)"myvalue", (Object)copy.getString("mykey", "null"));
            Assert.assertEquals((long)100L, (long)copy.getInteger("mynumber", 0));
            Assert.assertEquals((long)478236947162389746L, (long)copy.getLong("longvalue", 0L));
            Assert.assertEquals((double)3.141592502593994, (double)copy.getFloat("PI", 3.1415925f), (double)0.0);
            Assert.assertEquals((double)Math.E, (double)copy.getDouble("E", 0.0), (double)0.0);
            Assert.assertEquals((Object)true, (Object)copy.getBoolean("shouldbetrue", false));
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])copy.getBytes("bytes sequence", null));
            Assert.assertEquals(((Object)((Object)this)).getClass(), (Object)copy.getClass("myclass", null, ((Object)((Object)this)).getClass().getClassLoader()));
            Assert.assertEquals((Object)orig, (Object)copy);
            Assert.assertEquals((Object)orig.keySet(), (Object)copy.keySet());
            Assert.assertEquals((long)orig.hashCode(), (long)copy.hashCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCopyConstructor() {
        try {
            String key = "theKey";
            Configuration cfg1 = new Configuration();
            cfg1.setString("theKey", "value");
            Configuration cfg2 = new Configuration(cfg1);
            cfg2.setString("theKey", "another value");
            Assert.assertEquals((Object)"value", (Object)cfg1.getString("theKey", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOptionWithDefault() {
        Configuration cfg = new Configuration();
        cfg.setInteger("int-key", 11);
        cfg.setString("string-key", "abc");
        ConfigOption presentStringOption = ConfigOptions.key((String)"string-key").stringType().defaultValue((Object)"my-beautiful-default");
        ConfigOption presentIntOption = ConfigOptions.key((String)"int-key").intType().defaultValue((Object)87);
        Assert.assertEquals((Object)"abc", (Object)cfg.getString(presentStringOption));
        Assert.assertEquals((Object)"abc", (Object)cfg.getValue(presentStringOption));
        Assert.assertEquals((long)11L, (long)cfg.getInteger(presentIntOption));
        Assert.assertEquals((Object)"11", (Object)cfg.getValue(presentIntOption));
        ConfigOption stringOption = ConfigOptions.key((String)"test").stringType().defaultValue((Object)"my-beautiful-default");
        ConfigOption intOption = ConfigOptions.key((String)"test2").intType().defaultValue((Object)87);
        Assert.assertEquals((Object)"my-beautiful-default", (Object)cfg.getValue(stringOption));
        Assert.assertEquals((Object)"my-beautiful-default", (Object)cfg.getString(stringOption));
        Assert.assertEquals((Object)"override", (Object)cfg.getString(stringOption, "override"));
        Assert.assertEquals((long)87L, (long)cfg.getInteger(intOption));
        Assert.assertEquals((Object)"87", (Object)cfg.getValue(intOption));
    }

    @Test
    public void testOptionWithNoDefault() {
        Configuration cfg = new Configuration();
        cfg.setInteger("int-key", 11);
        cfg.setString("string-key", "abc");
        ConfigOption presentStringOption = ConfigOptions.key((String)"string-key").stringType().noDefaultValue();
        Assert.assertEquals((Object)"abc", (Object)cfg.getString(presentStringOption));
        Assert.assertEquals((Object)"abc", (Object)cfg.getValue(presentStringOption));
        ConfigOption stringOption = ConfigOptions.key((String)"test").stringType().noDefaultValue();
        Assert.assertNull((Object)cfg.getValue(stringOption));
        Assert.assertNull((Object)cfg.getString(stringOption));
        Assert.assertEquals((Object)"override", (Object)cfg.getString(stringOption, "override"));
    }

    @Test
    public void testDeprecatedKeys() {
        Configuration cfg = new Configuration();
        cfg.setInteger("the-key", 11);
        cfg.setInteger("old-key", 12);
        cfg.setInteger("older-key", 13);
        ConfigOption matchesFirst = ConfigOptions.key((String)"the-key").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesSecond = ConfigOptions.key((String)"does-not-exist").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesThird = ConfigOptions.key((String)"does-not-exist").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"foo", "older-key"});
        ConfigOption notContained = ConfigOptions.key((String)"does-not-exist").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"not-there", "also-not-there"});
        Assert.assertEquals((long)11L, (long)cfg.getInteger(matchesFirst));
        Assert.assertEquals((long)12L, (long)cfg.getInteger(matchesSecond));
        Assert.assertEquals((long)13L, (long)cfg.getInteger(matchesThird));
        Assert.assertEquals((long)-1L, (long)cfg.getInteger(notContained));
    }

    @Test
    public void testFallbackKeys() {
        Configuration cfg = new Configuration();
        cfg.setInteger("the-key", 11);
        cfg.setInteger("old-key", 12);
        cfg.setInteger("older-key", 13);
        ConfigOption matchesFirst = ConfigOptions.key((String)"the-key").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesSecond = ConfigOptions.key((String)"does-not-exist").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesThird = ConfigOptions.key((String)"does-not-exist").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"foo", "older-key"});
        ConfigOption notContained = ConfigOptions.key((String)"does-not-exist").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"not-there", "also-not-there"});
        Assert.assertEquals((long)11L, (long)cfg.getInteger(matchesFirst));
        Assert.assertEquals((long)12L, (long)cfg.getInteger(matchesSecond));
        Assert.assertEquals((long)13L, (long)cfg.getInteger(matchesThird));
        Assert.assertEquals((long)-1L, (long)cfg.getInteger(notContained));
    }

    @Test
    public void testFallbackAndDeprecatedKeys() {
        ConfigOption fallback = ConfigOptions.key((String)"fallback").intType().defaultValue((Object)-1);
        ConfigOption deprecated = ConfigOptions.key((String)"deprecated").intType().defaultValue((Object)-1);
        ConfigOption mainOption = ConfigOptions.key((String)"main").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{fallback.key()}).withDeprecatedKeys(new String[]{deprecated.key()});
        Configuration fallbackCfg = new Configuration();
        fallbackCfg.setInteger(fallback, 1);
        Assert.assertEquals((long)1L, (long)fallbackCfg.getInteger(mainOption));
        Configuration deprecatedCfg = new Configuration();
        deprecatedCfg.setInteger(deprecated, 2);
        Assert.assertEquals((long)2L, (long)deprecatedCfg.getInteger(mainOption));
        ConfigOption reversedMainOption = ConfigOptions.key((String)"main").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{deprecated.key()}).withFallbackKeys(new String[]{fallback.key()});
        Configuration deprecatedAndFallBackConfig = new Configuration();
        deprecatedAndFallBackConfig.setInteger(fallback, 1);
        deprecatedAndFallBackConfig.setInteger(deprecated, 2);
        Assert.assertEquals((long)1L, (long)deprecatedAndFallBackConfig.getInteger(mainOption));
        Assert.assertEquals((long)1L, (long)deprecatedAndFallBackConfig.getInteger(reversedMainOption));
    }

    @Test
    public void testRemove() {
        Configuration cfg = new Configuration();
        cfg.setInteger("a", 1);
        cfg.setInteger("b", 2);
        ConfigOption validOption = ConfigOptions.key((String)"a").intType().defaultValue((Object)-1);
        ConfigOption deprecatedOption = ConfigOptions.key((String)"c").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"d", "b"});
        ConfigOption unexistedOption = ConfigOptions.key((String)"e").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"f", "g", "j"});
        Assert.assertEquals((String)"Wrong expectation about size", (long)cfg.keySet().size(), (long)2L);
        Assert.assertTrue((String)"Expected 'validOption' is removed", (boolean)cfg.removeConfig(validOption));
        Assert.assertEquals((String)"Wrong expectation about size", (long)cfg.keySet().size(), (long)1L);
        Assert.assertTrue((String)"Expected 'existedOption' is removed", (boolean)cfg.removeConfig(deprecatedOption));
        Assert.assertEquals((String)"Wrong expectation about size", (long)cfg.keySet().size(), (long)0L);
        Assert.assertFalse((String)"Expected 'unexistedOption' is not removed", (boolean)cfg.removeConfig(unexistedOption));
    }

    @Test
    public void testRemoveKey() {
        Configuration cfg = new Configuration();
        String key1 = "a.b";
        String key2 = "c.d";
        cfg.setInteger(key1, 42);
        cfg.setInteger(key2, 44);
        cfg.setInteger(key2 + ".f1", 44);
        cfg.setInteger(key2 + ".f2", 44);
        cfg.setInteger("e.f", 1337);
        Assert.assertFalse((boolean)cfg.removeKey("not-existing-key"));
        Assert.assertTrue((boolean)cfg.removeKey(key1));
        Assert.assertFalse((boolean)cfg.containsKey(key1));
        Assert.assertTrue((boolean)cfg.removeKey(key2));
        Assert.assertThat((Object)cfg.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"e.f"}));
    }

    @Test
    public void testShouldParseValidStringToEnum() {
        Configuration configuration = new Configuration();
        configuration.setString(STRING_OPTION.key(), TestEnum.VALUE1.toString());
        TestEnum parsedEnumValue = (TestEnum)configuration.getEnum(TestEnum.class, STRING_OPTION);
        Assert.assertEquals((Object)((Object)TestEnum.VALUE1), (Object)((Object)parsedEnumValue));
    }

    @Test
    public void testShouldParseValidStringToEnumIgnoringCase() {
        Configuration configuration = new Configuration();
        configuration.setString(STRING_OPTION.key(), TestEnum.VALUE1.toString().toLowerCase());
        TestEnum parsedEnumValue = (TestEnum)configuration.getEnum(TestEnum.class, STRING_OPTION);
        Assert.assertEquals((Object)((Object)TestEnum.VALUE1), (Object)((Object)parsedEnumValue));
    }

    @Test
    public void testThrowsExceptionIfTryingToParseInvalidStringForEnum() {
        Configuration configuration = new Configuration();
        String invalidValueForTestEnum = "InvalidValueForTestEnum";
        configuration.setString(STRING_OPTION.key(), "InvalidValueForTestEnum");
        try {
            configuration.getEnum(TestEnum.class, STRING_OPTION);
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "Value for config option " + STRING_OPTION.key() + " must be one of [VALUE1, VALUE2] (was " + "InvalidValueForTestEnum" + ")";
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)expectedMessage));
        }
    }

    @Test
    public void testToMap() {
        Configuration configuration = new Configuration();
        String listValues = "value1;value2;value3";
        configuration.set(LIST_STRING_OPTION, Arrays.asList("value1;value2;value3".split(";")));
        String mapValues = "key1:value1,key2:value2";
        configuration.set(MAP_OPTION, Arrays.stream("key1:value1,key2:value2".split(",")).collect(Collectors.toMap(e -> e.split(":")[0], e -> e.split(":")[1])));
        Duration duration = Duration.ofMillis(3000L);
        configuration.set(DURATION_OPTION, (Object)duration);
        Assert.assertEquals((Object)"value1;value2;value3", configuration.toMap().get(LIST_STRING_OPTION.key()));
        Assert.assertEquals((Object)"key1:value1,key2:value2", configuration.toMap().get(MAP_OPTION.key()));
        Assert.assertEquals((Object)"3 s", configuration.toMap().get(DURATION_OPTION.key()));
    }

    @Test
    public void testMapNotContained() {
        Configuration cfg = new Configuration();
        Assert.assertFalse((boolean)cfg.getOptional(MAP_OPTION).isPresent());
        Assert.assertFalse((boolean)cfg.contains(MAP_OPTION));
    }

    @Test
    public void testMapWithPrefix() {
        Configuration cfg = new Configuration();
        cfg.setString(MAP_PROPERTY_1, "value1");
        cfg.setInteger(MAP_PROPERTY_2, 12);
        Assert.assertEquals((Object)cfg.get(MAP_OPTION), PROPERTIES_MAP);
        Assert.assertTrue((boolean)cfg.contains(MAP_OPTION));
    }

    @Test
    public void testMapWithoutPrefix() {
        Configuration cfg = new Configuration();
        cfg.set(MAP_OPTION, PROPERTIES_MAP);
        Assert.assertEquals((Object)cfg.get(MAP_OPTION), PROPERTIES_MAP);
        Assert.assertTrue((boolean)cfg.contains(MAP_OPTION));
    }

    @Test
    public void testMapNonPrefixHasPrecedence() {
        Configuration cfg = new Configuration();
        cfg.set(MAP_OPTION, PROPERTIES_MAP);
        cfg.setString(MAP_PROPERTY_1, "value1");
        cfg.setInteger(MAP_PROPERTY_2, 99999);
        Assert.assertEquals((Object)cfg.get(MAP_OPTION), PROPERTIES_MAP);
        Assert.assertTrue((boolean)cfg.contains(MAP_OPTION));
        Assert.assertTrue((boolean)cfg.containsKey(MAP_PROPERTY_1));
    }

    @Test
    public void testMapThatOverwritesPrefix() {
        Configuration cfg = new Configuration();
        cfg.setString(MAP_PROPERTY_1, "value1");
        cfg.setInteger(MAP_PROPERTY_2, 99999);
        cfg.set(MAP_OPTION, PROPERTIES_MAP);
        Assert.assertEquals((Object)cfg.get(MAP_OPTION), PROPERTIES_MAP);
        Assert.assertTrue((boolean)cfg.contains(MAP_OPTION));
        Assert.assertFalse((boolean)cfg.containsKey(MAP_PROPERTY_1));
    }

    @Test
    public void testMapRemovePrefix() {
        Configuration cfg = new Configuration();
        cfg.setString(MAP_PROPERTY_1, "value1");
        cfg.setInteger(MAP_PROPERTY_2, 99999);
        cfg.removeConfig(MAP_OPTION);
        Assert.assertFalse((boolean)cfg.contains(MAP_OPTION));
        Assert.assertFalse((boolean)cfg.containsKey(MAP_PROPERTY_1));
        Assert.assertFalse((boolean)cfg.containsKey(MAP_PROPERTY_2));
    }

    @Test
    public void testListParserErrorDoesNotLeakSensitiveData() {
        ConfigOption secret = ConfigOptions.key((String)"secret").stringType().asList().noDefaultValue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)secret.key())).isTrue();
        Configuration cfg = new Configuration();
        cfg.setString(secret.key(), "'secret_value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            List cfr_ignored_0 = (List)cfg.get(secret);
        }).isInstanceOf(IllegalArgumentException.class)).satisfies(new ThrowingConsumer[]{e -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)e)).doesNotContain(new CharSequence[]{"secret_value"});
        }});
    }

    @Test
    public void testMapParserErrorDoesNotLeakSensitiveData() {
        ConfigOption secret = ConfigOptions.key((String)"secret").mapType().noDefaultValue();
        Assertions.assertThat((boolean)GlobalConfiguration.isSensitive((String)secret.key())).isTrue();
        Configuration cfg = new Configuration();
        cfg.setString(secret.key(), "secret_value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Map cfr_ignored_0 = (Map)cfg.get(secret);
        }).isInstanceOf(IllegalArgumentException.class)).satisfies(new ThrowingConsumer[]{e -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)e)).doesNotContain(new CharSequence[]{"secret_value"});
        }});
    }

    static {
        PROPERTIES_MAP.put("prop1", "value1");
        PROPERTIES_MAP.put("prop2", "12");
        MAP_PROPERTY_1 = MAP_OPTION.key() + ".prop1";
        MAP_PROPERTY_2 = MAP_OPTION.key() + ".prop2";
    }

    static enum TestEnum {
        VALUE1,
        VALUE2;

    }
}

