/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class DelegatingConfigurationTest {
    @Test
    public void testIfDelegatesImplementAllMethods() throws IllegalArgumentException {
        Method[] confMethods = Configuration.class.getDeclaredMethods();
        Method[] delegateMethods = DelegatingConfiguration.class.getDeclaredMethods();
        for (Method configurationMethod : confMethods) {
            int mod = configurationMethod.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
            boolean hasMethod = false;
            block1: for (Method wrapperMethod : delegateMethods) {
                Class<?>[] configMethodParams;
                Class<?>[] wrapperMethodParams;
                if (!configurationMethod.getName().equals(wrapperMethod.getName()) || (wrapperMethodParams = wrapperMethod.getParameterTypes()).length != (configMethodParams = configurationMethod.getParameterTypes()).length) continue;
                for (int i = 0; i < wrapperMethodParams.length; ++i) {
                    if (wrapperMethodParams[i] != configMethodParams[i]) continue block1;
                }
                hasMethod = true;
                break;
            }
            Assert.assertTrue((String)("Configuration method '" + configurationMethod.getName() + "' has not been wrapped correctly in DelegatingConfiguration wrapper"), (boolean)hasMethod);
        }
    }

    @Test
    public void testDelegationConfigurationWithNullPrefix() {
        Configuration backingConf = new Configuration();
        backingConf.setValueInternal("test-key", (Object)"value", false);
        DelegatingConfiguration configuration = new DelegatingConfiguration(backingConf, null);
        Set keySet = configuration.keySet();
        Assert.assertEquals((Object)keySet, (Object)backingConf.keySet());
    }

    @Test
    public void testDelegationConfigurationWithPrefix() {
        String prefix = "pref-";
        String expectedKey = "key";
        Configuration backingConf = new Configuration();
        backingConf.setValueInternal(prefix + expectedKey, (Object)"value", false);
        DelegatingConfiguration configuration = new DelegatingConfiguration(backingConf, prefix);
        Set keySet = configuration.keySet();
        Assert.assertEquals((long)keySet.size(), (long)1L);
        Assert.assertEquals(keySet.iterator().next(), (Object)expectedKey);
        backingConf = new Configuration();
        backingConf.setValueInternal("test-key", (Object)"value", false);
        configuration = new DelegatingConfiguration(backingConf, prefix);
        keySet = configuration.keySet();
        Assert.assertTrue((boolean)keySet.isEmpty());
    }

    @Test
    public void testDelegationConfigurationToMapConsistentWithAddAllToProperties() {
        Configuration conf = new Configuration();
        conf.setString("k0", "v0");
        conf.setString("prefix.k1", "v1");
        conf.setString("prefix.prefix.k2", "v2");
        conf.setString("k3.prefix.prefix.k3", "v3");
        DelegatingConfiguration dc = new DelegatingConfiguration(conf, "prefix.");
        Properties properties = new Properties();
        dc.addAllToProperties(properties);
        Map map = dc.toMap();
        Properties mapProperties = new Properties();
        for (Map.Entry entry : map.entrySet()) {
            mapProperties.put(entry.getKey(), entry.getValue());
        }
        Assert.assertEquals((Object)properties, (Object)mapProperties);
    }

    @Test
    public void testSetReturnsDelegatingConfiguration() {
        Configuration conf = new Configuration();
        DelegatingConfiguration delegatingConf = new DelegatingConfiguration(conf, "prefix.");
        Assertions.assertThat((Object)delegatingConf.set(CoreOptions.DEFAULT_PARALLELISM, (Object)1)).isSameAs((Object)delegatingConf);
    }
}

