/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RefCountedFileWithStreamTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void writeShouldSucceed() throws IOException {
        byte[] content = RefCountedFileWithStreamTest.bytesOf("hello world");
        RefCountedFileWithStream fileUnderTest = this.getClosedRefCountedFileWithContent(content);
        long fileLength = fileUnderTest.getLength();
        Assert.assertEquals((long)content.length, (long)fileLength);
    }

    @Test
    public void closeShouldNotReleaseReference() throws IOException {
        this.getClosedRefCountedFileWithContent("hello world");
        this.verifyTheFileIsStillThere();
    }

    @Test(expected=IOException.class)
    public void writeAfterCloseShouldThrowException() throws IOException {
        RefCountedFileWithStream fileUnderTest = this.getClosedRefCountedFileWithContent("hello world");
        byte[] content = RefCountedFileWithStreamTest.bytesOf("Hello Again");
        fileUnderTest.write(content, 0, content.length);
    }

    @Test(expected=IOException.class)
    public void flushAfterCloseShouldThrowException() throws IOException {
        RefCountedFileWithStream fileUnderTest = this.getClosedRefCountedFileWithContent("hello world");
        fileUnderTest.flush();
    }

    private void verifyTheFileIsStillThere() throws IOException {
        try (Stream<Path> files = Files.list(this.temporaryFolder.getRoot().toPath());){
            Assert.assertEquals((long)1L, (long)files.count());
        }
    }

    private RefCountedFileWithStream getClosedRefCountedFileWithContent(String content) throws IOException {
        return this.getClosedRefCountedFileWithContent(RefCountedFileWithStreamTest.bytesOf(content));
    }

    private RefCountedFileWithStream getClosedRefCountedFileWithContent(byte[] content) throws IOException {
        File newFile = new File(this.temporaryFolder.getRoot(), ".tmp_" + UUID.randomUUID());
        OutputStream out = Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW);
        RefCountedFileWithStream fileUnderTest = RefCountedFileWithStream.newFile((File)newFile, (OutputStream)out);
        fileUnderTest.write(content, 0, content.length);
        fileUnderTest.closeStream();
        return fileUnderTest;
    }

    private static byte[] bytesOf(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

