/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.testutils.TestFileUtils;

public final class TestConfigUtils {
    public static Configuration loadGlobalConf(String[] keys, String[] values, File tempDir) throws IOException {
        return TestConfigUtils.loadGlobalConf(TestConfigUtils.getConfAsString(keys, values), tempDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration loadGlobalConf(String contents, File tempDir) throws IOException {
        File confDir;
        while ((confDir = new File(tempDir, TestFileUtils.randomFileName())).exists()) {
        }
        try {
            Configuration configuration;
            confDir.mkdirs();
            File confFile = new File(confDir, "flink-conf.yaml");
            try {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(confFile));){
                    writer.write(contents);
                }
                configuration = GlobalConfiguration.loadConfiguration((String)confDir.getAbsolutePath());
                confFile.delete();
            }
            catch (Throwable throwable) {
                confFile.delete();
                throw throwable;
            }
            return configuration;
        }
        finally {
            confDir.delete();
        }
    }

    public static String getConfAsString(String[] keys, String[] values) {
        if (keys == null || values == null || keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            bld.append(keys[i]);
            bld.append(": ");
            bld.append(values[i]);
            bld.append(System.lineSeparator());
        }
        return bld.toString();
    }

    private TestConfigUtils() {
    }
}

