/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrimitiveDataTypeTest {
    private PipedInputStream in;
    private PipedOutputStream out;
    private DataInputView mIn;
    private DataOutputView mOut;

    @Before
    public void setup() throws Exception {
        this.in = new PipedInputStream(1000);
        this.out = new PipedOutputStream(this.in);
        this.mIn = new DataInputViewStreamWrapper((InputStream)this.in);
        this.mOut = new DataOutputViewStreamWrapper((OutputStream)this.out);
    }

    @Test
    public void testIntValue() {
        IntValue int0 = new IntValue(10);
        Assert.assertEquals((long)10L, (long)int0.getValue());
        IntValue int1 = new IntValue(10);
        IntValue int2 = new IntValue(-10);
        IntValue int3 = new IntValue(20);
        Assert.assertEquals((long)int0.compareTo(int0), (long)0L);
        Assert.assertEquals((long)int0.compareTo(int1), (long)0L);
        Assert.assertEquals((long)int0.compareTo(int2), (long)1L);
        Assert.assertEquals((long)int0.compareTo(int3), (long)-1L);
        try {
            int0.write(this.mOut);
            int2.write(this.mOut);
            int3.write(this.mOut);
            IntValue int1n = new IntValue();
            IntValue int2n = new IntValue();
            IntValue int3n = new IntValue();
            int1n.read(this.mIn);
            int2n.read(this.mIn);
            int3n.read(this.mIn);
            Assert.assertEquals((long)int0.compareTo(int1n), (long)0L);
            Assert.assertEquals((long)int0.getValue(), (long)int1n.getValue());
            Assert.assertEquals((long)int2.compareTo(int2n), (long)0L);
            Assert.assertEquals((long)int2.getValue(), (long)int2n.getValue());
            Assert.assertEquals((long)int3.compareTo(int3n), (long)0L);
            Assert.assertEquals((long)int3.getValue(), (long)int3n.getValue());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDoubleValue() {
        DoubleValue double0 = new DoubleValue(10.2);
        Assert.assertEquals((double)10.2, (double)double0.getValue(), (double)1.0E-4);
        DoubleValue double1 = new DoubleValue(10.2);
        DoubleValue double2 = new DoubleValue(-10.5);
        DoubleValue double3 = new DoubleValue(20.2);
        Assert.assertEquals((long)double0.compareTo(double0), (long)0L);
        Assert.assertEquals((long)double0.compareTo(double1), (long)0L);
        Assert.assertEquals((long)double0.compareTo(double2), (long)1L);
        Assert.assertEquals((long)double0.compareTo(double3), (long)-1L);
        try {
            double0.write(this.mOut);
            double2.write(this.mOut);
            double3.write(this.mOut);
            DoubleValue double1n = new DoubleValue();
            DoubleValue double2n = new DoubleValue();
            DoubleValue double3n = new DoubleValue();
            double1n.read(this.mIn);
            double2n.read(this.mIn);
            double3n.read(this.mIn);
            Assert.assertEquals((long)double0.compareTo(double1n), (long)0L);
            Assert.assertEquals((double)double0.getValue(), (double)double1n.getValue(), (double)1.0E-4);
            Assert.assertEquals((long)double2.compareTo(double2n), (long)0L);
            Assert.assertEquals((double)double2.getValue(), (double)double2n.getValue(), (double)1.0E-4);
            Assert.assertEquals((long)double3.compareTo(double3n), (long)0L);
            Assert.assertEquals((double)double3.getValue(), (double)double3n.getValue(), (double)1.0E-4);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testStringValue() {
        StringValue string0 = new StringValue((CharSequence)"This is a test");
        StringValue stringThis = new StringValue((CharSequence)"This");
        StringValue stringIsA = new StringValue((CharSequence)"is a");
        Assert.assertEquals((Object)"This is a test", (Object)string0.toString());
        StringValue string1 = new StringValue((CharSequence)"This is a test");
        StringValue string2 = new StringValue((CharSequence)"This is a tesa");
        StringValue string3 = new StringValue((CharSequence)"This is a tesz");
        StringValue string4 = new StringValue((CharSequence)"\u00dcnlaut \u00dftring \u00b5 avec \u00e9 y \u00a2");
        CharSequence chars5 = string1.subSequence(0, 4);
        StringValue string5 = (StringValue)chars5;
        StringValue string6 = (StringValue)string0.subSequence(0, string0.length());
        StringValue string7 = (StringValue)string0.subSequence(5, 9);
        StringValue string8 = (StringValue)string0.subSequence(0, 0);
        Assert.assertTrue((string0.compareTo(string0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((string0.compareTo(string1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((string0.compareTo(string2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((string0.compareTo(string3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stringThis.equals((Object)chars5));
        Assert.assertTrue((stringThis.compareTo(string5) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((string0.compareTo(string6) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((stringIsA.compareTo(string7) == 0 ? 1 : 0) != 0);
        string7.setValue((CharSequence)"This is a test");
        Assert.assertTrue((stringIsA.compareTo(string7) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((string0.compareTo(string7) == 0 ? 1 : 0) != 0);
        string7.setValue((CharSequence)"is a");
        Assert.assertTrue((stringIsA.compareTo(string7) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((string0.compareTo(string7) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)stringIsA.hashCode(), (long)string7.hashCode());
        Assert.assertEquals((long)string7.length(), (long)4L);
        Assert.assertEquals((Object)"is a", (Object)string7.getValue());
        Assert.assertEquals((long)string8.length(), (long)0L);
        Assert.assertEquals((Object)"", (Object)string8.getValue());
        Assert.assertEquals((long)115L, (long)string7.charAt(1));
        try {
            string7.charAt(5);
            Assert.fail((String)"Exception should have been thrown when accessing characters out of bounds.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            string0.write(this.mOut);
            string4.write(this.mOut);
            string2.write(this.mOut);
            string3.write(this.mOut);
            string7.write(this.mOut);
            StringValue string1n = new StringValue();
            StringValue string2n = new StringValue();
            StringValue string3n = new StringValue();
            StringValue string4n = new StringValue();
            StringValue string7n = new StringValue();
            string1n.read(this.mIn);
            string4n.read(this.mIn);
            string2n.read(this.mIn);
            string3n.read(this.mIn);
            string7n.read(this.mIn);
            Assert.assertEquals((long)string0.compareTo(string1n), (long)0L);
            Assert.assertEquals((Object)string0.toString(), (Object)string1n.toString());
            Assert.assertEquals((long)string4.compareTo(string4n), (long)0L);
            Assert.assertEquals((Object)string4.toString(), (Object)string4n.toString());
            Assert.assertEquals((long)string2.compareTo(string2n), (long)0L);
            Assert.assertEquals((Object)string2.toString(), (Object)string2n.toString());
            Assert.assertEquals((long)string3.compareTo(string3n), (long)0L);
            Assert.assertEquals((Object)string3.toString(), (Object)string3n.toString());
            Assert.assertEquals((long)string7.compareTo(string7n), (long)0L);
            Assert.assertEquals((Object)string7.toString(), (Object)string7n.toString());
            try {
                string7n.charAt(5);
                Assert.fail((String)"Exception should have been thrown when accessing characters out of bounds.");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testPactNull() {
        NullValue pn1 = new NullValue();
        NullValue pn2 = new NullValue();
        Assert.assertEquals((String)"PactNull not equal to other PactNulls.", (Object)pn1, (Object)pn2);
        Assert.assertEquals((String)"PactNull not equal to other PactNulls.", (Object)pn2, (Object)pn1);
        Assert.assertFalse((String)"PactNull equal to other null.", (boolean)pn1.equals(null));
        NullValue pn = new NullValue();
        int numWrites = 13;
        try {
            int i;
            for (i = 0; i < 13; ++i) {
                pn.write(this.mOut);
            }
            for (i = 0; i < 13; ++i) {
                pn.read(this.mIn);
            }
            Assert.assertEquals((String)"Reading PactNull does not consume the same data as was written.", (long)0L, (long)this.in.available());
        }
        catch (IOException ioex) {
            Assert.fail((String)("An exception occurred in the testcase: " + ioex.getMessage()));
        }
    }
}

