/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecordTest {
    private static final long SEED = 354144423270432543L;
    private final Random rand = new Random(354144423270432543L);
    private DataInputView in;
    private DataOutputView out;
    private final StringValue origVal1 = new StringValue((CharSequence)"Hello World!");
    private final DoubleValue origVal2 = new DoubleValue(Math.PI);
    private final IntValue origVal3 = new IntValue(1337);

    @Before
    public void setUp() throws Exception {
        PipedInputStream pipeIn = new PipedInputStream(0x100000);
        PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
        this.in = new DataInputViewStreamWrapper((InputStream)pipeIn);
        this.out = new DataOutputViewStreamWrapper((OutputStream)pipeOut);
    }

    @Test
    public void testEmptyRecordSerialization() {
        try {
            Record empty = new Record();
            empty.write(this.out);
            empty.read(this.in);
            Assert.assertTrue((String)"Deserialized Empty record is not another empty record.", (empty.getNumFields() == 0 ? 1 : 0) != 0);
            empty = new Record();
            empty.write(this.out);
            empty = new Record();
            empty.read(this.in);
            Assert.assertTrue((String)"Deserialized Empty record is not another empty record.", (empty.getNumFields() == 0 ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testAddField() {
        try {
            Record record = new Record();
            Assert.assertTrue((record.getNumFields() == 0 ? 1 : 0) != 0);
            record.addField((Value)this.origVal1);
            Assert.assertTrue((record.getNumFields() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)this.origVal1.getValue().equals(((StringValue)record.getField(0, StringValue.class)).getValue()));
            record = new Record();
            for (int i = 0; i < 100; ++i) {
                IntValue orig = new IntValue(this.rand.nextInt());
                record.addField((Value)orig);
                IntValue rec = (IntValue)record.getField(i, IntValue.class);
                Assert.assertTrue((record.getNumFields() == i + 1 ? 1 : 0) != 0);
                Assert.assertTrue((orig.getValue() == rec.getValue() ? 1 : 0) != 0);
            }
            record = new Record((Value)this.origVal1, (Value)this.origVal2);
            record.addField((Value)this.origVal3);
            Assert.assertTrue((record.getNumFields() == 3 ? 1 : 0) != 0);
            StringValue recVal1 = (StringValue)record.getField(0, StringValue.class);
            DoubleValue recVal2 = (DoubleValue)record.getField(1, DoubleValue.class);
            IntValue recVal3 = (IntValue)record.getField(2, IntValue.class);
            Assert.assertTrue((String)"The value of the first field has changed", (boolean)recVal1.equals((Object)this.origVal1));
            Assert.assertTrue((String)"The value of the second field changed", (boolean)recVal2.equals((Object)this.origVal2));
            Assert.assertTrue((String)"The value of the third field has changed", (boolean)recVal3.equals((Object)this.origVal3));
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testRemoveField() {
        Record record = null;
        int oldLen = 0;
        record = new Record((Value)this.origVal1, (Value)this.origVal2);
        record.addField((Value)this.origVal3);
        record.removeField(1);
        Assert.assertTrue((record.getNumFields() == 2 ? 1 : 0) != 0);
        StringValue recVal1 = (StringValue)record.getField(0, StringValue.class);
        IntValue recVal2 = (IntValue)record.getField(1, IntValue.class);
        Assert.assertTrue((boolean)recVal1.getValue().equals(this.origVal1.getValue()));
        Assert.assertTrue((recVal2.getValue() == this.origVal3.getValue() ? 1 : 0) != 0);
        record = this.generateFilledDenseRecord(100);
        oldLen = record.getNumFields();
        record.removeField(0);
        Assert.assertTrue((record.getNumFields() == oldLen - 1 ? 1 : 0) != 0);
        oldLen = record.getNumFields();
        record.removeField(oldLen - 1);
        Assert.assertTrue((record.getNumFields() == oldLen - 1 ? 1 : 0) != 0);
        record = this.generateFilledDenseRecord(100);
        for (int i = 0; i < 100; ++i) {
            oldLen = record.getNumFields();
            int pos = this.rand.nextInt(record.getNumFields());
            record.removeField(pos);
            Assert.assertTrue((record.getNumFields() == oldLen - 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetNullInt() {
        try {
            Record record = this.generateFilledDenseRecord(58);
            record.setNull(42);
            Assert.assertTrue((record.getNumFields() == 58 ? 1 : 0) != 0);
            Assert.assertTrue((record.getField(42, IntValue.class) == null ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testSetNullLong() {
        try {
            Record record = this.generateFilledDenseRecord(58);
            long mask = this.generateRandomBitmask(58);
            record.setNull(mask);
            for (int i = 0; i < 58; ++i) {
                if ((1L << i & mask) == 0L) continue;
                Assert.assertTrue((record.getField(i, IntValue.class) == null ? 1 : 0) != 0);
            }
            Assert.assertTrue((record.getNumFields() == 58 ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testSetNullLongArray() {
        try {
            Record record = this.generateFilledDenseRecord(612);
            long[] mask = new long[]{1L, 1L, 1L, 1L};
            record.setNull(mask);
            Assert.assertTrue((record.getField(0, IntValue.class) == null ? 1 : 0) != 0);
            Assert.assertTrue((record.getField(64, IntValue.class) == null ? 1 : 0) != 0);
            Assert.assertTrue((record.getField(128, IntValue.class) == null ? 1 : 0) != 0);
            Assert.assertTrue((record.getField(192, IntValue.class) == null ? 1 : 0) != 0);
            mask = new long[10];
            for (int i = 0; i < mask.length; ++i) {
                int offset = i * 64;
                int numFields = offset + 64 < record.getNumFields() ? 64 : record.getNumFields() - offset;
                mask[i] = this.generateRandomBitmask(numFields);
            }
            record.setNull(mask);
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testUpdateBinaryRepresentations() {
        try {
            Record r = new Record();
            IntValue i1 = new IntValue(1);
            IntValue i2 = new IntValue(2);
            try {
                r.setField(1, (Value)i1);
                r.setField(3, (Value)i2);
                r.setNumFields(5);
                r.updateBinaryRepresenation();
                i1 = new IntValue(3);
                i2 = new IntValue(4);
                r.setField(7, (Value)i1);
                r.setField(8, (Value)i2);
                r.updateBinaryRepresenation();
                Assert.assertTrue((((IntValue)r.getField(1, IntValue.class)).getValue() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(3, IntValue.class)).getValue() == 2 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(7, IntValue.class)).getValue() == 3 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(8, IntValue.class)).getValue() == 4 ? 1 : 0) != 0);
            }
            catch (RuntimeException re) {
                Assert.fail((String)("Error updating binary representation: " + re.getMessage()));
            }
            r = new Record();
            for (int i = 0; i < 8; ++i) {
                r.setField(i, (Value)new IntValue(i));
            }
            try {
                r.write(this.out);
                r = new Record();
                r.read(this.in);
                r.setField(1, (Value)new IntValue(10));
                r.setField(4, (Value)new StringValue((CharSequence)"Some long value"));
                r.setField(5, (Value)new StringValue((CharSequence)"An even longer value"));
                r.setField(10, (Value)new IntValue(10));
                r.write(this.out);
                r = new Record();
                r.read(this.in);
                Assert.assertTrue((((IntValue)r.getField(0, IntValue.class)).getValue() == 0 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(1, IntValue.class)).getValue() == 10 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(2, IntValue.class)).getValue() == 2 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(3, IntValue.class)).getValue() == 3 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)((StringValue)r.getField(4, StringValue.class)).getValue().equals("Some long value"));
                Assert.assertTrue((boolean)((StringValue)r.getField(5, StringValue.class)).getValue().equals("An even longer value"));
                Assert.assertTrue((((IntValue)r.getField(6, IntValue.class)).getValue() == 6 ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(7, IntValue.class)).getValue() == 7 ? 1 : 0) != 0);
                Assert.assertTrue((r.getField(8, IntValue.class) == null ? 1 : 0) != 0);
                Assert.assertTrue((r.getField(9, IntValue.class) == null ? 1 : 0) != 0);
                Assert.assertTrue((((IntValue)r.getField(10, IntValue.class)).getValue() == 10 ? 1 : 0) != 0);
            }
            catch (IOException | RuntimeException re) {
                Assert.fail((String)("Error updating binary representation: " + re.getMessage()));
            }
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testDeSerialization() {
        try {
            StringValue origValue1 = new StringValue((CharSequence)"Hello World!");
            IntValue origValue2 = new IntValue(1337);
            Record record1 = new Record((Value)origValue1, (Value)origValue2);
            Record record2 = new Record();
            try {
                record1.write(this.out);
                record2.read(this.in);
                Assert.assertTrue((record1.getNumFields() == record2.getNumFields() ? 1 : 0) != 0);
                StringValue rec1Val1 = (StringValue)record1.getField(0, StringValue.class);
                IntValue rec1Val2 = (IntValue)record1.getField(1, IntValue.class);
                StringValue rec2Val1 = (StringValue)record2.getField(0, StringValue.class);
                IntValue rec2Val2 = (IntValue)record2.getField(1, IntValue.class);
                Assert.assertTrue((boolean)origValue1.equals((Object)rec1Val1));
                Assert.assertTrue((boolean)origValue2.equals((Object)rec1Val2));
                Assert.assertTrue((boolean)origValue1.equals((Object)rec2Val1));
                Assert.assertTrue((boolean)origValue2.equals((Object)rec2Val2));
            }
            catch (IOException e) {
                Assert.fail((String)"Error writing Record");
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    @Test
    public void testClear() throws IOException {
        try {
            Record record = new Record((Value)new IntValue(42));
            record.write(this.out);
            Assert.assertEquals((long)42L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            record.setField(0, (Value)new IntValue(23));
            record.write(this.out);
            Assert.assertEquals((long)23L, (long)((IntValue)record.getField(0, IntValue.class)).getValue());
            record.clear();
            Assert.assertEquals((long)0L, (long)record.getNumFields());
            Record record2 = new Record((Value)new IntValue(42));
            record2.read(this.in);
            Assert.assertEquals((long)42L, (long)((IntValue)record2.getField(0, IntValue.class)).getValue());
            record2.read(this.in);
            Assert.assertEquals((long)23L, (long)((IntValue)record2.getField(0, IntValue.class)).getValue());
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    private Record generateFilledDenseRecord(int numFields) {
        Record record = new Record();
        for (int i = 0; i < numFields; ++i) {
            record.addField((Value)new IntValue(this.rand.nextInt()));
        }
        return record;
    }

    private long generateRandomBitmask(int numFields) {
        long bitmask = 0L;
        long tmp = 0L;
        for (int i = 0; i < numFields; ++i) {
            tmp = this.rand.nextBoolean() ? 1L : 0L;
            bitmask |= tmp << i;
        }
        return bitmask;
    }

    @Test
    public void blackBoxTests() {
        try {
            int i;
            Value[][] values;
            for (Value[] value : values = new Value[][]{new Value[0], {new IntValue(55), new StringValue((CharSequence)"Hi there!"), new LongValue(457354357357135L), new IntValue(345), new IntValue(-468), new StringValue((CharSequence)"This is the message and the message is this!"), new LongValue(0L), new IntValue(465)}, {new IntValue(55), new StringValue((CharSequence)"Hi there!"), new LongValue(457354357357135L), new IntValue(345), new IntValue(-468), new StringValue((CharSequence)"This is the message and the message is this!"), new LongValue(0L), new IntValue(465), new IntValue(55), new StringValue((CharSequence)"Hi there!"), new LongValue(457354357357135L), new IntValue(345), new IntValue(-468), new StringValue((CharSequence)"This is the message and the message is this!"), new LongValue(0L), new IntValue(465)}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}, {new IntValue(56), null, new IntValue(-7628761), new StringValue((CharSequence)"A test string")}, {new StringValue((CharSequence)RecordTest.createRandomString(this.rand, 15)), new StringValue((CharSequence)RecordTest.createRandomString(this.rand, 1015)), new StringValue((CharSequence)RecordTest.createRandomString(this.rand, 32))}, {new StringValue((CharSequence)RecordTest.createRandomString(this.rand, 1265)), null, new StringValue((CharSequence)RecordTest.createRandomString(this.rand, 855))}}) {
                RecordTest.blackboxTestRecordWithValues(value, this.rand, this.in, this.out);
            }
            for (i = 0; i < 10000; ++i) {
                Value[] fields = RecordTest.createRandomValues(this.rand, 0, 32);
                RecordTest.blackboxTestRecordWithValues(fields, this.rand, this.in, this.out);
            }
            for (i = 0; i < 1000; ++i) {
                Value[] fields = RecordTest.createRandomValues(this.rand, 20, 150);
                RecordTest.blackboxTestRecordWithValues(fields, this.rand, this.in, this.out);
            }
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    static void blackboxTestRecordWithValues(Value[] values, Random rnd, DataInputView reader, DataOutputView writer) throws Exception {
        int pos;
        int i;
        int pos2;
        int i2;
        int[] permutation1 = RecordTest.createPermutation(rnd, values.length);
        int[] permutation2 = RecordTest.createPermutation(rnd, values.length);
        Record rec = new Record();
        for (i2 = 0; i2 < values.length; ++i2) {
            pos2 = permutation1[i2];
            rec.setField(pos2, values[pos2]);
        }
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        for (i2 = 0; i2 < values.length; ++i2) {
            pos2 = permutation1[i2];
            rec.setField(pos2, values[pos2]);
        }
        rec.updateBinaryRepresenation();
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        int updatePos = rnd.nextInt(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            if (i == updatePos) {
                rec.updateBinaryRepresenation();
            }
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        if (updatePos == values.length) {
            rec.updateBinaryRepresenation();
        }
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        for (i = 0; i < values.length; ++i) {
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        rec.write(writer);
        rec = new Record();
        rec.read(reader);
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        for (i = 0; i < values.length; ++i) {
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        rec.write(writer);
        rec.read(reader);
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        updatePos = rnd.nextInt(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            if (i == updatePos) {
                rec.write(writer);
                rec = new Record();
                rec.read(reader);
            }
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        if (updatePos == values.length) {
            rec.write(writer);
            rec = new Record();
            rec.read(reader);
        }
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        updatePos = rnd.nextInt(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            if (i == updatePos) {
                rec.write(writer);
                rec.read(reader);
            }
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        if (updatePos == values.length) {
            rec.write(writer);
            rec.read(reader);
        }
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        updatePos = rnd.nextInt(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            if (i == updatePos) {
                rec.write(writer);
                rec = new Record();
                rec.read(reader);
            }
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        rec.write(writer);
        rec = new Record();
        rec.read(reader);
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
        rec = new Record();
        updatePos = rnd.nextInt(values.length + 1);
        for (i = 0; i < values.length; ++i) {
            if (i == updatePos) {
                rec.write(writer);
                rec.read(reader);
            }
            pos = permutation1[i];
            rec.setField(pos, values[pos]);
        }
        rec.write(writer);
        rec.read(reader);
        RecordTest.testAllRetrievalMethods(rec, permutation2, values);
    }

    public static void testAllRetrievalMethods(Record rec, int[] permutation, Value[] expected) throws Exception {
        Value retrieved;
        Value e;
        int pos;
        int i;
        for (i = 0; i < expected.length; ++i) {
            pos = permutation[i];
            e = expected[pos];
            if (e == null) {
                retrieved = rec.getField(pos, IntValue.class);
                if (retrieved == null) continue;
                Assert.fail((String)("Value at position " + pos + " expected to be null in " + Arrays.toString(expected)));
                continue;
            }
            retrieved = rec.getField(pos, e.getClass());
            if (e.equals(retrieved)) continue;
            Assert.assertEquals((String)("Wrong value at position " + pos + " in " + Arrays.toString(expected)), (Object)e, (Object)retrieved);
        }
        for (i = 0; i < expected.length; ++i) {
            pos = permutation[i];
            e = expected[pos];
            if (e == null) {
                retrieved = rec.getField(pos, (Value)new IntValue());
                if (retrieved == null) continue;
                Assert.fail((String)("Value at position " + pos + " expected to be null in " + Arrays.toString(expected)));
                continue;
            }
            retrieved = rec.getField(pos, (Value)e.getClass().newInstance());
            if (e.equals(retrieved)) continue;
            Assert.assertEquals((String)("Wrong value at position " + pos + " in " + Arrays.toString(expected)), (Object)e, (Object)retrieved);
        }
        for (i = 0; i < expected.length; ++i) {
            pos = permutation[i];
            e = expected[pos];
            if (e == null) {
                if (!rec.getFieldInto(pos, (Value)new IntValue())) continue;
                Assert.fail((String)("Value at position " + pos + " expected to be null in " + Arrays.toString(expected)));
                continue;
            }
            retrieved = (Value)e.getClass().newInstance();
            if (!rec.getFieldInto(pos, retrieved)) {
                Assert.fail((String)("Value at position " + pos + " expected to be not null in " + Arrays.toString(expected)));
            }
            if (e.equals(retrieved)) continue;
            Assert.assertEquals((String)("Wrong value at position " + pos + " in " + Arrays.toString(expected)), (Object)e, (Object)retrieved);
        }
    }

    @Test
    public void testUnionFields() {
        try {
            Value[][] values = new Value[][]{{new IntValue(56), null, new IntValue(-7628761)}, {null, new StringValue((CharSequence)"Hello Test!"), null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}, {new IntValue(56), new IntValue(56), new IntValue(56), new IntValue(56), null, null, null}, {null, null, null, null, new IntValue(56), new IntValue(56), new IntValue(56)}, {new IntValue(43), new IntValue(42), new IntValue(41)}, {new IntValue(-463), new IntValue(-464), new IntValue(-465)}};
            for (int i = 0; i < values.length - 1; i += 2) {
                this.testUnionFieldsForValues(values[i], values[i + 1], this.rand);
                this.testUnionFieldsForValues(values[i + 1], values[i], this.rand);
            }
        }
        catch (Throwable t) {
            Assert.fail((String)("Test failed due to an exception: " + t.getMessage()));
        }
    }

    private void testUnionFieldsForValues(Value[] rec1fields, Value[] rec2fields, Random rnd) {
        int pos;
        int i;
        Record rec1 = RecordTest.createRecord(rec1fields);
        Record rec2 = RecordTest.createRecord(rec2fields);
        rec1.updateBinaryRepresenation();
        rec2.updateBinaryRepresenation();
        rec1.unionFields(rec2);
        RecordTest.checkUnionedRecord(rec1, rec1fields, rec2fields);
        rec1 = RecordTest.createRecord(rec1fields);
        rec2 = RecordTest.createRecord(rec2fields);
        rec1.unionFields(rec2);
        RecordTest.checkUnionedRecord(rec1, rec1fields, rec2fields);
        rec1 = RecordTest.createRecord(rec1fields);
        rec2 = RecordTest.createRecord(rec2fields);
        rec1.updateBinaryRepresenation();
        rec1.unionFields(rec2);
        RecordTest.checkUnionedRecord(rec1, rec1fields, rec2fields);
        rec1 = RecordTest.createRecord(rec1fields);
        rec2 = RecordTest.createRecord(rec2fields);
        rec2.updateBinaryRepresenation();
        rec1.unionFields(rec2);
        RecordTest.checkUnionedRecord(rec1, rec1fields, rec2fields);
        rec1 = new Record();
        int[] permutation1 = RecordTest.createPermutation(rnd, rec1fields.length);
        int[] permutation2 = RecordTest.createPermutation(rnd, rec2fields.length);
        int updatePos = rnd.nextInt(rec1fields.length + 1);
        for (i = 0; i < rec1fields.length; ++i) {
            if (i == updatePos) {
                rec1.updateBinaryRepresenation();
            }
            pos = permutation1[i];
            rec1.setField(pos, rec1fields[pos]);
        }
        if (updatePos == rec1fields.length) {
            rec1.updateBinaryRepresenation();
        }
        updatePos = rnd.nextInt(rec2fields.length + 1);
        for (i = 0; i < rec2fields.length; ++i) {
            if (i == updatePos) {
                rec2.updateBinaryRepresenation();
            }
            pos = permutation2[i];
            rec2.setField(pos, rec2fields[pos]);
        }
        if (updatePos == rec2fields.length) {
            rec2.updateBinaryRepresenation();
        }
        rec1.unionFields(rec2);
        RecordTest.checkUnionedRecord(rec1, rec1fields, rec2fields);
    }

    private static void checkUnionedRecord(Record union, Value[] rec1fields, Value[] rec2fields) {
        for (int i = 0; i < Math.max(rec1fields.length, rec2fields.length); ++i) {
            Value retrieved;
            Value expected = i < rec1fields.length ? (i < rec2fields.length ? (rec1fields[i] == null ? rec2fields[i] : rec1fields[i]) : rec1fields[i]) : rec2fields[i];
            if (expected == null) {
                retrieved = union.getField(i, IntValue.class);
                Assert.assertNull((String)("Value at position " + i + " expected to be null in " + Arrays.toString(rec1fields) + " U " + Arrays.toString(rec2fields)), (Object)retrieved);
                continue;
            }
            retrieved = union.getField(i, expected.getClass());
            Assert.assertEquals((String)("Wrong value at position " + i + " in " + Arrays.toString(rec1fields) + " U " + Arrays.toString(rec2fields)), (Object)expected, (Object)retrieved);
        }
    }

    public static Record createRecord(Value[] fields) {
        Record rec = new Record();
        for (int i = 0; i < fields.length; ++i) {
            rec.setField(i, fields[i]);
        }
        return rec;
    }

    public static Value[] createRandomValues(Random rnd, int minNum, int maxNum) {
        int numFields = rnd.nextInt(maxNum - minNum + 1) + minNum;
        Value[] values = new Value[numFields];
        block7: for (int i = 0; i < numFields; ++i) {
            int type = rnd.nextInt(7);
            switch (type) {
                case 0: {
                    values[i] = new IntValue(rnd.nextInt());
                    continue block7;
                }
                case 1: {
                    values[i] = new LongValue(rnd.nextLong());
                    continue block7;
                }
                case 2: {
                    values[i] = new DoubleValue(rnd.nextDouble());
                    continue block7;
                }
                case 3: {
                    values[i] = NullValue.getInstance();
                    continue block7;
                }
                case 4: {
                    values[i] = new StringValue((CharSequence)RecordTest.createRandomString(rnd));
                    continue block7;
                }
                default: {
                    values[i] = null;
                }
            }
        }
        return values;
    }

    public static String createRandomString(Random rnd) {
        return RecordTest.createRandomString(rnd, rnd.nextInt(150));
    }

    public static String createRandomString(Random rnd, int length) {
        StringBuilder sb = new StringBuilder();
        sb.ensureCapacity(length);
        for (int i = 0; i < length; ++i) {
            sb.append((char)(rnd.nextInt(26) + 65));
        }
        return sb.toString();
    }

    public static int[] createPermutation(Random rnd, int length) {
        int i;
        int[] a = new int[length];
        for (i = 0; i < length; ++i) {
            a[i] = i;
        }
        for (i = 0; i < length; ++i) {
            int pos1 = rnd.nextInt(length);
            int pos2 = rnd.nextInt(length);
            int temp = a[pos1];
            a[pos1] = a[pos2];
            a[pos2] = temp;
        }
        return a;
    }
}

