/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.TestFieldParser;
import org.junit.Assert;
import org.junit.Test;

public class FieldParserTest {
    @Test
    public void testDelimiterNext() throws Exception {
        byte[] bytes = "aaabc".getBytes();
        byte[] delim = "aa".getBytes();
        Assert.assertTrue((boolean)FieldParser.delimiterNext((byte[])bytes, (int)0, (byte[])delim));
        Assert.assertTrue((boolean)FieldParser.delimiterNext((byte[])bytes, (int)1, (byte[])delim));
        Assert.assertFalse((boolean)FieldParser.delimiterNext((byte[])bytes, (int)2, (byte[])delim));
    }

    @Test
    public void testEndsWithDelimiter() throws Exception {
        byte[] bytes = "aabc".getBytes();
        byte[] delim = "ab".getBytes();
        Assert.assertFalse((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)0, (byte[])delim));
        Assert.assertFalse((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)1, (byte[])delim));
        Assert.assertTrue((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)2, (byte[])delim));
        Assert.assertFalse((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)3, (byte[])delim));
    }

    @Test
    public void testNextStringEndPos() throws Exception {
        TestFieldParser parser = new TestFieldParser();
        byte[] singleCharDelim = "|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        byte[] bytes1 = "a|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        Assert.assertEquals((long)1L, (long)parser.nextStringEndPos(bytes1, 0, bytes1.length, singleCharDelim));
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(bytes1, 1, bytes1.length, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(bytes1, 1, 1, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(bytes1, 2, bytes1.length, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        byte[] bytes2 = "a||".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(bytes2, 1, bytes2.length, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        byte[] bytes3 = "a|c".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(bytes3, 1, bytes3.length, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        parser.resetParserState();
        Assert.assertEquals((long)3L, (long)parser.nextStringEndPos(bytes3, 2, bytes3.length, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.NONE, (Object)parser.getErrorState());
        byte[] bytes4 = "a|c|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)3L, (long)parser.nextStringEndPos(bytes4, 2, bytes4.length, singleCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.NONE, (Object)parser.getErrorState());
        byte[] multiCharDelim = "|#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        byte[] mBytes1 = "a|#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)1L, (long)parser.nextStringEndPos(mBytes1, 0, mBytes1.length, multiCharDelim));
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(mBytes1, 1, mBytes1.length, multiCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(mBytes1, 1, 1, multiCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        byte[] mBytes2 = "a|#||#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(mBytes2, 1, mBytes2.length, multiCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        byte[] mBytes3 = "a|#|b".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)-1L, (long)parser.nextStringEndPos(mBytes3, 1, mBytes3.length, multiCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
        parser.resetParserState();
        Assert.assertEquals((long)5L, (long)parser.nextStringEndPos(mBytes3, 2, mBytes3.length, multiCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.NONE, (Object)parser.getErrorState());
        byte[] mBytes4 = "a|#|b|#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assert.assertEquals((long)5L, (long)parser.nextStringEndPos(mBytes4, 2, mBytes4.length, multiCharDelim));
        Assert.assertEquals((Object)FieldParser.ParseErrorState.NONE, (Object)parser.getErrorState());
    }
}

