/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionUtilsTest
extends TestLogger {
    @Test
    public void testStringifyNullException() {
        Assert.assertNotNull((Object)"(null)");
        Assert.assertEquals((Object)"(null)", (Object)ExceptionUtils.stringifyException(null));
    }

    @Test
    public void testJvmFatalError() {
        Assert.assertFalse((boolean)ExceptionUtils.isJvmFatalError((Throwable)new Error()));
        Assert.assertFalse((boolean)ExceptionUtils.isJvmFatalError((Throwable)new LinkageError()));
        Assert.assertTrue((boolean)ExceptionUtils.isJvmFatalError((Throwable)new InternalError()));
        Assert.assertTrue((boolean)ExceptionUtils.isJvmFatalError((Throwable)new UnknownError()));
    }

    @Test
    public void testRethrowFatalError() {
        try {
            ExceptionUtils.rethrowIfFatalError((Throwable)new InternalError());
            Assert.fail();
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        ExceptionUtils.rethrowIfFatalError((Throwable)new NoClassDefFoundError());
    }

    @Test
    public void testFindThrowableByType() {
        Assert.assertTrue((boolean)ExceptionUtils.findThrowable((Throwable)new RuntimeException(new IllegalStateException()), IllegalStateException.class).isPresent());
    }

    @Test
    public void testExceptionStripping() {
        FlinkException expectedException = new FlinkException("test exception");
        Throwable strippedException = ExceptionUtils.stripException((Throwable)new RuntimeException(new RuntimeException((Throwable)expectedException)), RuntimeException.class);
        Assert.assertThat((Object)strippedException, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedException)));
    }

    @Test
    public void testInvalidExceptionStripping() {
        FlinkException expectedException = new FlinkException((Throwable)new RuntimeException((Throwable)new FlinkException("inner exception")));
        Throwable strippedException = ExceptionUtils.stripException((Throwable)expectedException, RuntimeException.class);
        Assert.assertThat((Object)strippedException, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedException)));
    }

    @Test
    public void testTryEnrichTaskExecutorErrorCanHandleNullValueWithoutCausingException() {
        ExceptionUtils.tryEnrichOutOfMemoryError(null, (String)"", (String)"", (String)"");
    }

    @Test
    public void testUpdateDetailMessageOfBasicThrowable() {
        OutOfMemoryError rootThrowable = new OutOfMemoryError("old message");
        ExceptionUtils.updateDetailMessage((Throwable)rootThrowable, t -> "new message");
        Assert.assertThat((Object)rootThrowable.getMessage(), (Matcher)Matchers.is((Object)"new message"));
    }

    @Test
    public void testUpdateDetailMessageOfRelevantThrowableAsCause() {
        IllegalArgumentException oomCause = new IllegalArgumentException("another message deep down in the cause tree");
        Throwable oom = new OutOfMemoryError("old message").initCause(oomCause);
        oom.setStackTrace(new StackTraceElement[]{new StackTraceElement("class", "method", "file", 1)});
        oom.addSuppressed(new NullPointerException());
        IllegalStateException rootThrowable = new IllegalStateException("another message", oom);
        ExceptionUtils.updateDetailMessage((Throwable)rootThrowable, t -> t.getClass().equals(OutOfMemoryError.class) ? "new message" : null);
        Assert.assertThat((Object)rootThrowable.getCause(), (Matcher)CoreMatchers.sameInstance((Object)oom));
        Assert.assertThat((Object)rootThrowable.getCause().getMessage(), (Matcher)Matchers.is((Object)"new message"));
        Assert.assertThat((Object)rootThrowable.getCause().getStackTrace(), (Matcher)Matchers.is((Object)oom.getStackTrace()));
        Assert.assertThat((Object)rootThrowable.getCause().getSuppressed(), (Matcher)Matchers.is((Object)oom.getSuppressed()));
        Assert.assertThat((Object)rootThrowable.getCause().getCause(), (Matcher)CoreMatchers.sameInstance((Object)oomCause));
    }

    @Test
    public void testUpdateDetailMessageWithoutRelevantThrowable() {
        IllegalStateException originalThrowable = new IllegalStateException("root message", new IllegalArgumentException("cause message"));
        ExceptionUtils.updateDetailMessage((Throwable)originalThrowable, t -> null);
        Assert.assertThat((Object)originalThrowable.getMessage(), (Matcher)Matchers.is((Object)"root message"));
        Assert.assertThat((Object)originalThrowable.getCause().getMessage(), (Matcher)Matchers.is((Object)"cause message"));
    }

    @Test
    public void testUpdateDetailMessageOfNullWithoutException() {
        ExceptionUtils.updateDetailMessage(null, t -> "new message");
    }

    @Test
    public void testUpdateDetailMessageWithMissingPredicate() {
        Exception root = new Exception("old message");
        ExceptionUtils.updateDetailMessage((Throwable)root, null);
        Assert.assertThat((Object)root.getMessage(), (Matcher)Matchers.is((Object)"old message"));
    }

    @Test
    public void testIsMetaspaceOutOfMemoryErrorCanHandleNullValue() {
        Assert.assertFalse((boolean)ExceptionUtils.isMetaspaceOutOfMemoryError(null));
    }

    @Test
    public void testIsDirectOutOfMemoryErrorCanHandleNullValue() {
        Assert.assertFalse((boolean)ExceptionUtils.isDirectOutOfMemoryError(null));
    }
}

