/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Optional;
import org.apache.flink.util.Reference;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class ReferenceTest {
    @Test
    public void testOwnedReferenceIsOwned() {
        Reference value = Reference.owned((Object)"foobar");
        Assertions.assertThat((boolean)value.isOwned()).isTrue();
    }

    @Test
    public void testBorrowedReferenceIsNotOwned() {
        Reference value = Reference.borrowed((Object)"foobar");
        Assertions.assertThat((boolean)value.isOwned()).isFalse();
    }

    @Test
    public void testOwnedReferenceReturnsSomeOwned() {
        String value = "foobar";
        Reference owned = Reference.owned((Object)"foobar");
        Assertions.assertThat((Optional)owned.owned()).hasValue((Object)"foobar");
    }

    @Test
    public void testBorrowedReferenceReturnsEmptyOwned() {
        Reference value = Reference.borrowed((Object)"foobar");
        Assertions.assertThat((Optional)value.owned()).isEmpty();
    }
}

