/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.LongMinimum;
import org.junit.Assert;
import org.junit.Test;

public class LongMinimumTest {
    @Test
    public void testGet() {
        LongMinimum min = new LongMinimum();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)min.getLocalValue());
    }

    @Test
    public void testResetLocal() {
        LongMinimum min = new LongMinimum();
        long value = 9876543210L;
        min.add(value);
        Assert.assertEquals((long)value, (long)min.getLocalValue());
        min.resetLocal();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)min.getLocalValue());
    }

    @Test
    public void testAdd() {
        LongMinimum min = new LongMinimum();
        min.add(1234567890L);
        min.add(9876543210L);
        min.add(-9876543210L);
        min.add(-1234567890L);
        Assert.assertEquals((long)-9876543210L, (long)min.getLocalValue());
    }

    @Test
    public void testMerge() {
        LongMinimum min1 = new LongMinimum();
        min1.add(1234567890987654321L);
        LongMinimum min2 = new LongMinimum();
        min2.add(5678909876543210123L);
        min2.merge((Accumulator)min1);
        Assert.assertEquals((long)1234567890987654321L, (long)min2.getLocalValue());
        min1.merge((Accumulator)min2);
        Assert.assertEquals((long)1234567890987654321L, (long)min1.getLocalValue());
    }

    @Test
    public void testClone() {
        LongMinimum min = new LongMinimum();
        long value = 4242424242424242L;
        min.add(value);
        LongMinimum clone = min.clone();
        Assert.assertEquals((long)value, (long)clone.getLocalValue());
    }
}

