/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.util.UUID;
import org.apache.flink.api.common.eventtime.TestingWatermarkOutput;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkMatchers;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutputMultiplexer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class WatermarkOutputMultiplexerTest {
    @Test
    public void singleImmediateWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput.emitWatermark(new Watermark(0L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(0L)));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void singleImmediateIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput.markIdle();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void singleImmediateWatermarkAfterIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput.markIdle();
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)true));
        watermarkOutput.emitWatermark(new Watermark(0L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(0L)));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void multipleImmediateWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput3 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        watermarkOutput3.markIdle();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(2L)));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenImmediateOutputBecomesIdleWatermarkAdvances() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(2L)));
        watermarkOutput1.markIdle();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(5L)));
    }

    @Test
    public void combinedWatermarkDoesNotRegressWhenIdleOutputRegresses() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        watermarkOutput1.markIdle();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(5L)));
        watermarkOutput1.emitWatermark(new Watermark(3L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(5L)));
    }

    @Test
    public void noCombinedDeferredUpdateWhenWeHaveZeroOutputs() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void deferredOutputDoesNotImmediatelyAdvanceWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(0L));
        watermarkOutput2.emitWatermark(new Watermark(1L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.nullValue());
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(0L)));
    }

    @Test
    public void singleDeferredWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput.emitWatermark(new Watermark(0L));
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(0L)));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void singleDeferredIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput.markIdle();
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void singleDeferredWatermarkAfterIdleness() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput.markIdle();
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)true));
        watermarkOutput.emitWatermark(new Watermark(0L));
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(0L)));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void multipleDeferredWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput watermarkOutput1 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        WatermarkOutput watermarkOutput2 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        WatermarkOutput watermarkOutput3 = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        watermarkOutput1.emitWatermark(new Watermark(2L));
        watermarkOutput2.emitWatermark(new Watermark(5L));
        watermarkOutput3.markIdle();
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(2L)));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void immediateUpdatesTakeDeferredUpdatesIntoAccount() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        WatermarkOutput immediateOutput = WatermarkOutputMultiplexerTest.createImmediateOutput(multiplexer);
        WatermarkOutput deferredOutput = WatermarkOutputMultiplexerTest.createDeferredOutput(multiplexer);
        deferredOutput.emitWatermark(new Watermark(5L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        immediateOutput.emitWatermark(new Watermark(2L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(2L)));
    }

    @Test
    public void immediateUpdateOnSameOutputAsDeferredUpdateDoesNotRegress() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        String id = "test-id";
        multiplexer.registerNewOutput("test-id", watermark -> {});
        WatermarkOutput immediateOutput = multiplexer.getImmediateOutput("test-id");
        WatermarkOutput deferredOutput = multiplexer.getDeferredOutput("test-id");
        deferredOutput.emitWatermark(new Watermark(5L));
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(5L)));
        immediateOutput.emitWatermark(new Watermark(2L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(5L)));
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is(WatermarkMatchers.watermark(5L)));
    }

    @Test
    public void lowerImmediateUpdateOnSameOutputDoesNotEmitCombinedUpdate() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        String id = "1234-test";
        multiplexer.registerNewOutput("1234-test", watermark -> {});
        WatermarkOutput immediateOutput = multiplexer.getImmediateOutput("1234-test");
        WatermarkOutput deferredOutput = multiplexer.getDeferredOutput("1234-test");
        deferredOutput.emitWatermark(new Watermark(5L));
        immediateOutput.emitWatermark(new Watermark(2L));
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testRemoveUnblocksWatermarks() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        long lowTimestamp = 156765L;
        long highTimestamp = 156775L;
        multiplexer.registerNewOutput("lower", watermark -> {});
        multiplexer.registerNewOutput("higher", watermark -> {});
        multiplexer.getImmediateOutput("lower").emitWatermark(new Watermark(156765L));
        multiplexer.unregisterOutput("lower");
        multiplexer.getImmediateOutput("higher").emitWatermark(new Watermark(156775L));
        Assert.assertEquals((long)156775L, (long)underlyingWatermarkOutput.lastWatermark().getTimestamp());
    }

    @Test
    public void testRemoveOfLowestDoesNotImmediatelyAdvanceWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        long lowTimestamp = -4343L;
        long highTimestamp = -4333L;
        multiplexer.registerNewOutput("lower", watermark -> {});
        multiplexer.registerNewOutput("higher", watermark -> {});
        multiplexer.getImmediateOutput("lower").emitWatermark(new Watermark(-4343L));
        multiplexer.getImmediateOutput("higher").emitWatermark(new Watermark(-4333L));
        multiplexer.unregisterOutput("lower");
        Assert.assertEquals((long)-4343L, (long)underlyingWatermarkOutput.lastWatermark().getTimestamp());
    }

    @Test
    public void testRemoveOfHighestDoesNotRetractWatermark() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        long lowTimestamp = 1L;
        long highTimestamp = 2L;
        multiplexer.registerNewOutput("higher", watermark -> {});
        multiplexer.getImmediateOutput("higher").emitWatermark(new Watermark(2L));
        multiplexer.unregisterOutput("higher");
        multiplexer.registerNewOutput("lower", watermark -> {});
        multiplexer.getImmediateOutput("lower").emitWatermark(new Watermark(1L));
        Assert.assertEquals((long)2L, (long)underlyingWatermarkOutput.lastWatermark().getTimestamp());
    }

    @Test
    public void testRemoveRegisteredReturnValue() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        multiplexer.registerNewOutput("does-exist", watermark -> {});
        boolean unregistered = multiplexer.unregisterOutput("does-exist");
        Assert.assertTrue((boolean)unregistered);
    }

    @Test
    public void testRemoveNotRegisteredReturnValue() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        boolean unregistered = multiplexer.unregisterOutput("does-not-exist");
        Assert.assertFalse((boolean)unregistered);
    }

    @Test
    public void testNotEmittingIdleAfterAllSplitsRemoved() {
        TestingWatermarkOutput underlyingWatermarkOutput = WatermarkOutputMultiplexerTest.createTestingWatermarkOutput();
        WatermarkOutputMultiplexer multiplexer = new WatermarkOutputMultiplexer((WatermarkOutput)underlyingWatermarkOutput);
        Watermark emittedWatermark = new Watermark(1L);
        String id = UUID.randomUUID().toString();
        multiplexer.registerNewOutput(id, watermark -> {});
        WatermarkOutput immediateOutput = multiplexer.getImmediateOutput(id);
        immediateOutput.emitWatermark(emittedWatermark);
        multiplexer.unregisterOutput(id);
        multiplexer.onPeriodicEmit();
        Assert.assertThat((Object)underlyingWatermarkOutput.lastWatermark(), (Matcher)CoreMatchers.equalTo((Object)emittedWatermark));
        Assert.assertThat((Object)underlyingWatermarkOutput.isIdle(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    private static WatermarkOutput createImmediateOutput(WatermarkOutputMultiplexer multiplexer) {
        String id = UUID.randomUUID().toString();
        multiplexer.registerNewOutput(id, watermark -> {});
        return multiplexer.getImmediateOutput(id);
    }

    private static WatermarkOutput createDeferredOutput(WatermarkOutputMultiplexer multiplexer) {
        String id = UUID.randomUUID().toString();
        multiplexer.registerNewOutput(id, watermark -> {});
        return multiplexer.getDeferredOutput(id);
    }

    private static TestingWatermarkOutput createTestingWatermarkOutput() {
        return new TestingWatermarkOutput();
    }
}

