/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.apache.flink.api.common.io.GlobFilePathFilter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

public class GlobFilePathFilterTest {
    @Test
    public void testDefaultConstructorCreateMatchAllFilter() {
        GlobFilePathFilter matcher = new GlobFilePathFilter();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isFalse();
    }

    @Test
    public void testMatchAllFilesByDefault() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.emptyList(), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isFalse();
    }

    @Test
    public void testExcludeFilesNotInIncludePatterns() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/*"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir1/file.txt"))).isTrue();
    }

    @Test
    public void testExcludeFilesIfMatchesExclude() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/*"), Collections.singletonList("dir/file.txt"));
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/file.txt"))).isTrue();
    }

    @Test
    public void testIncludeFileWithAnyCharacterMatcher() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/?.txt"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/a.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/aa.txt"))).isTrue();
    }

    @Test
    public void testIncludeFileWithCharacterSetMatcher() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/[acd].txt"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/a.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/c.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/d.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/z.txt"))).isTrue();
    }

    @Test
    public void testIncludeFileWithCharacterRangeMatcher() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("dir/[a-d].txt"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/a.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/b.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/c.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/d.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("dir/z.txt"))).isTrue();
    }

    @Test
    public void testExcludeHDFSFile() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.singletonList("/dir/file2.txt"));
        Assertions.assertThat((boolean)matcher.filterPath(new Path("hdfs:///dir/file1.txt"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("hdfs:///dir/file2.txt"))).isTrue();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("hdfs:///dir/file3.txt"))).isFalse();
    }

    @Test
    public void testExcludeFilenameWithStart() {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).as("Windows does not allow asterisks in file names.", new Object[0])).isFalse();
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.singletonList("\\*"));
        Assertions.assertThat((boolean)matcher.filterPath(new Path("*"))).isTrue();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("**"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("other.txt"))).isFalse();
    }

    @Test
    public void testSingleStarPattern() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("*"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b"))).isTrue();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b/c"))).isTrue();
    }

    @Test
    public void testDoubleStarPattern() {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.emptyList());
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b"))).isFalse();
        Assertions.assertThat((boolean)matcher.filterPath(new Path("a/b/c"))).isFalse();
    }

    @Test
    public void testIncluePatternIsNull() {
        Assertions.assertThatThrownBy(() -> new GlobFilePathFilter(null, Collections.emptyList())).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testExcludePatternIsNull() {
        Assertions.assertThatThrownBy(() -> new GlobFilePathFilter(Collections.singletonList("**"), null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void testGlobFilterSerializable() throws IOException {
        GlobFilePathFilter matcher = new GlobFilePathFilter(Collections.singletonList("**"), Collections.emptyList());
        GlobFilePathFilter matcherCopy = (GlobFilePathFilter)CommonTestUtils.createCopySerializable((Serializable)matcher);
        Assertions.assertThat((boolean)matcherCopy.filterPath(new Path("a"))).isFalse();
        Assertions.assertThat((boolean)matcherCopy.filterPath(new Path("a/b"))).isFalse();
        Assertions.assertThat((boolean)matcherCopy.filterPath(new Path("a/b/c"))).isFalse();
    }
}

