/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.junit.Assert;
import org.junit.Test;

public class SingleInputSemanticPropertiesTest {
    @Test
    public void testGetTargetFields() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 1);
        sp.addForwardedField(1, 4);
        sp.addForwardedField(2, 3);
        sp.addForwardedField(3, 2);
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 2).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 3).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(0, 4));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(0, 4).size());
        sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        sp.addForwardedField(0, 4);
        sp.addForwardedField(1, 1);
        sp.addForwardedField(1, 2);
        sp.addForwardedField(1, 3);
        Assert.assertEquals((long)2L, (long)sp.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)3L, (long)sp.getForwardingTargetFields(0, 1).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3)));
        Assert.assertNotNull((Object)sp.getForwardingTargetFields(0, 2));
        Assert.assertEquals((long)0L, (long)sp.getForwardingTargetFields(0, 2).size());
    }

    @Test
    public void testGetSourceField() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 1);
        sp.addForwardedField(1, 4);
        sp.addForwardedField(2, 3);
        sp.addForwardedField(3, 2);
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 1));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 4));
        Assert.assertEquals((long)2L, (long)sp.getForwardingSourceField(0, 3));
        Assert.assertEquals((long)3L, (long)sp.getForwardingSourceField(0, 2));
        Assert.assertTrue((sp.getForwardingSourceField(0, 0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingSourceField(0, 5) < 0 ? 1 : 0) != 0);
        sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        sp.addForwardedField(0, 4);
        sp.addForwardedField(1, 1);
        sp.addForwardedField(1, 2);
        sp.addForwardedField(1, 3);
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 0));
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 4));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 1));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 2));
        Assert.assertEquals((long)1L, (long)sp.getForwardingSourceField(0, 3));
        Assert.assertTrue((sp.getForwardingSourceField(0, 5) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReadSet() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addReadFields(new FieldSet(new int[]{0, 1}));
        Assert.assertEquals((long)2L, (long)sp.getReadFields(0).size());
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(1)));
        sp.addReadFields(new FieldSet(Integer.valueOf(3)));
        Assert.assertEquals((long)3L, (long)sp.getReadFields(0).size());
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(3)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testAddForwardedFieldsTargetTwice() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 2);
        sp.addForwardedField(1, 2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetTargetFieldInvalidIndex() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        sp.getForwardingTargetFields(1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetSourceFieldInvalidIndex() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addForwardedField(0, 0);
        sp.getForwardingSourceField(1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetReadFieldsInvalidIndex() {
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        sp.addReadFields(new FieldSet(new int[]{0, 1}));
        sp.getReadFields(1);
    }

    @Test
    public void testAllForwardedSingleInputSemProps() {
        SingleInputSemanticProperties.AllFieldsForwardedProperties sp = new SingleInputSemanticProperties.AllFieldsForwardedProperties();
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 0).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 1).size());
        Assert.assertEquals((long)1L, (long)sp.getForwardingTargetFields(0, 123).size());
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 123).contains(Integer.valueOf(123)));
        Assert.assertEquals((long)0L, (long)sp.getForwardingSourceField(0, 0));
        Assert.assertEquals((long)2L, (long)sp.getForwardingSourceField(0, 2));
        Assert.assertEquals((long)123L, (long)sp.getForwardingSourceField(0, 123));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAllForwardedSingleInputSemPropsInvalidIndex1() {
        SingleInputSemanticProperties.AllFieldsForwardedProperties sp = new SingleInputSemanticProperties.AllFieldsForwardedProperties();
        sp.getForwardingSourceField(1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAllForwardedSingleInputSemPropsInvalidIndex2() {
        SingleInputSemanticProperties.AllFieldsForwardedProperties sp = new SingleInputSemanticProperties.AllFieldsForwardedProperties();
        sp.getForwardingTargetFields(1, 0);
    }
}

