/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.junit.Assert;
import org.junit.Test;

public class MapOperatorTest
implements Serializable {
    @Test
    public void testMapPlain() {
        try {
            MapFunction<String, Integer> parser = new MapFunction<String, Integer>(){

                public Integer map(String value) {
                    return Integer.parseInt(value);
                }
            };
            MapOperatorBase op = new MapOperatorBase((MapFunction)parser, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), "TestMapper");
            ArrayList<String> input = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5", "6"));
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, null, executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, null, executionConfig);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)resultMutableSafe);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)resultRegular);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMapWithRuntimeContext() {
        try {
            String taskName = "Test Task";
            final AtomicBoolean opened = new AtomicBoolean();
            final AtomicBoolean closed = new AtomicBoolean();
            RichMapFunction<String, Integer> parser = new RichMapFunction<String, Integer>(){

                public void open(OpenContext openContext) throws Exception {
                    opened.set(true);
                    RuntimeContext ctx = this.getRuntimeContext();
                    Assert.assertEquals((long)0L, (long)ctx.getTaskInfo().getIndexOfThisSubtask());
                    Assert.assertEquals((long)1L, (long)ctx.getTaskInfo().getNumberOfParallelSubtasks());
                    Assert.assertEquals((Object)"Test Task", (Object)ctx.getTaskInfo().getTaskName());
                }

                public Integer map(String value) {
                    return Integer.parseInt(value);
                }

                public void close() throws Exception {
                    closed.set(true);
                }
            };
            MapOperatorBase op = new MapOperatorBase((MapFunction)parser, new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), "Test Task");
            ArrayList<String> input = new ArrayList<String>(Arrays.asList("1", "2", "3", "4", "5", "6"));
            HashMap accumulatorMap = new HashMap();
            HashMap cpTasks = new HashMap();
            TaskInfoImpl taskInfo = new TaskInfoImpl("Test Task", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)resultMutableSafe);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)resultRegular);
            Assert.assertTrue((boolean)opened.get());
            Assert.assertTrue((boolean)closed.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

