/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.junit.Assert;
import org.junit.Test;

public class FieldSetTest {
    @Test
    public void testFieldSetConstructors() {
        FieldSetTest.check(new FieldSet(), new int[0]);
        FieldSetTest.check(FieldSet.EMPTY_SET, new int[0]);
        FieldSetTest.check(new FieldSet(Integer.valueOf(14)), 14);
        FieldSetTest.check(new FieldSet(Integer.valueOf(3)), 3);
        FieldSetTest.check(new FieldSet(new int[]{7, 4, 1}), 1, 4, 7);
        FieldSetTest.check(new FieldSet(new int[]{7, 4, 1, 4, 7, 1, 4, 2}), 1, 4, 2, 7);
    }

    @Test
    public void testFieldSetAdds() {
        FieldSetTest.check(new FieldSet().addField(Integer.valueOf(1)).addField(Integer.valueOf(2)), 1, 2);
        FieldSetTest.check(FieldSet.EMPTY_SET.addField(Integer.valueOf(3)).addField(Integer.valueOf(2)), 3, 2);
        FieldSetTest.check(new FieldSet(Integer.valueOf(13)).addFields(new FieldSet(new int[]{17, 31, 42})), 17, 13, 42, 31);
        FieldSetTest.check(new FieldSet(Integer.valueOf(14)).addFields(new FieldSet(Integer.valueOf(17))), 17, 14);
        FieldSetTest.check(new FieldSet(Integer.valueOf(3)).addFields(new int[]{2, 8, 5, 7}), 3, 2, 8, 5, 7);
        FieldSetTest.check(new FieldSet().addFields(new FieldSet()), new int[0]);
        FieldSetTest.check(new FieldSet().addFields(new FieldSet(new int[]{3, 4})), 4, 3);
        FieldSetTest.check(new FieldSet(new int[]{5, 1}).addFields(new FieldSet()), 5, 1);
    }

    @Test
    public void testImmutability() {
        FieldSet s1 = new FieldSet();
        FieldSet s2 = new FieldSet(Integer.valueOf(5));
        FieldSet s3 = new FieldSet(Integer.valueOf(7));
        FieldSet s4 = new FieldSet(new int[]{5, 4, 7, 6});
        s1.addFields(s2).addFields(s3);
        s2.addFields(s4);
        s4.addFields(s1);
        s1.addField(Integer.valueOf(14));
        s2.addFields(new int[]{78, 13, 66, 3});
        Assert.assertEquals((long)0L, (long)s1.size());
        Assert.assertEquals((long)1L, (long)s2.size());
        Assert.assertEquals((long)1L, (long)s3.size());
        Assert.assertEquals((long)4L, (long)s4.size());
    }

    @Test
    public void testAddListToSet() {
        FieldSetTest.check(new FieldSet().addField(Integer.valueOf(1)).addFields((FieldSet)new FieldList(new int[]{14, 3, 1})), 1, 3, 14);
    }

    private static void check(FieldSet set, int ... elements) {
        if (elements == null) {
            Assert.assertEquals((long)0L, (long)set.size());
            return;
        }
        Assert.assertEquals((long)elements.length, (long)set.size());
        for (int i : elements) {
            set.contains(Integer.valueOf(i));
        }
        Arrays.sort(elements);
        int[] arr = set.toArray();
        Arrays.sort(arr);
        Assert.assertTrue((boolean)Arrays.equals(arr, elements));
        int[] fromIter = new int[set.size()];
        Iterator iter = set.iterator();
        for (int i = 0; i < fromIter.length; ++i) {
            fromIter[i] = (Integer)iter.next();
        }
        Assert.assertFalse((boolean)iter.hasNext());
        Arrays.sort(fromIter);
        Assert.assertTrue((boolean)Arrays.equals(fromIter, elements));
    }
}

