/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeutils.ThreadContextClassLoader;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassVisitor;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassWriter;
import org.apache.flink.shaded.asm9.org.objectweb.asm.commons.ClassRemapper;
import org.apache.flink.shaded.asm9.org.objectweb.asm.commons.Remapper;
import org.apache.flink.shaded.asm9.org.objectweb.asm.commons.SimpleRemapper;

public final class ClassRelocator {
    public static <T> Class<? extends T> relocate(Class<?> originalClass) {
        ClassRegistry remapping = new ClassRegistry(originalClass);
        ClassRenamer classRenamer = new ClassRenamer(remapping);
        Map<String, byte[]> newClassBytes = classRenamer.remap();
        return ClassRelocator.patchClass(newClassBytes, remapping);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> patchClass(Map<String, byte[]> newClasses, ClassRegistry remapping) {
        ByteClassLoader renamingClassLoader = new ByteClassLoader(remapping.getRoot().getClassLoader(), newClasses);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(renamingClassLoader);){
            Class<?> clazz = renamingClassLoader.loadClass(remapping.getRootNewName());
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class ByteClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> remappedClasses;

        private ByteClassLoader(ClassLoader parent, Map<String, byte[]> remappedClasses) {
            super(new URL[0], parent);
            this.remappedClasses = remappedClasses;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.remappedClasses.remove(name);
            if (bytes == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }
    }

    private static final class ClassRenamer {
        private final ClassRegistry renaming;

        ClassRenamer(ClassRegistry renaming) {
            this.renaming = renaming;
        }

        Map<String, byte[]> remap() {
            Map renames = this.renaming.remappingAsPathNames();
            return this.renaming.getDefinedClassesUnderRoot().stream().filter(klass -> klass.getClassLoader() != null).collect(Collectors.toMap(this.renaming::newNameFor, classToTransform -> {
                ClassReader providerClassReader = ClassRenamer.classReaderFor(classToTransform);
                ClassWriter transformedProvider = ClassRenamer.remap(renames, providerClassReader);
                return transformedProvider.toByteArray();
            }));
        }

        private static ClassWriter remap(Map<String, String> reMapping, ClassReader providerClassReader) {
            ClassWriter cw = new ClassWriter(0);
            ClassRemapper remappingClassAdapter = new ClassRemapper((ClassVisitor)cw, (Remapper)new SimpleRemapper(reMapping));
            providerClassReader.accept((ClassVisitor)remappingClassAdapter, 8);
            return cw;
        }

        private static ClassReader classReaderFor(Class<?> providerClass) {
            String classAsPath = providerClass.getName().replace('.', '/') + ".class";
            InputStream in = providerClass.getClassLoader().getResourceAsStream(classAsPath);
            try {
                return new ClassReader(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ClassRegistry {
        private static final AtomicInteger GENERATED_ID = new AtomicInteger(0);
        private final Class<?> root;
        private final Map<Class<?>, String> targetNames;

        ClassRegistry(Class<?> root) {
            this.root = root;
            this.targetNames = ClassRegistry.definedClasses(root).filter(type -> type.getAnnotation(RelocateClass.class) != null).collect(Collectors.toMap(Function.identity(), type -> type.getAnnotation(RelocateClass.class).value()));
            this.targetNames.put(root, root.getName() + String.format("$generated%d$", GENERATED_ID.incrementAndGet()));
        }

        public Class<?> getRoot() {
            return this.root;
        }

        String getRootNewName() {
            return this.newNameFor(this.root);
        }

        String newNameFor(Class<?> oldClass) {
            return this.targetNames.getOrDefault(oldClass, oldClass.getName());
        }

        Set<Class<?>> getDefinedClassesUnderRoot() {
            return ClassRegistry.definedClasses(this.root).collect(Collectors.toSet());
        }

        private Map<String, String> remappingAsPathNames() {
            return this.targetNames.entrySet().stream().collect(Collectors.toMap(e -> ClassRegistry.pathName((Class)e.getKey()), e -> ClassRegistry.pathName((String)e.getValue())));
        }

        private static String pathName(String className) {
            return className.replace('.', '/');
        }

        private static String pathName(Class<?> javaClass) {
            return javaClass.getName().replace('.', '/');
        }

        private static Stream<Class<?>> definedClasses(Class<?> klass) {
            Stream nestedClass = Arrays.stream(klass.getClasses()).flatMap(ClassRegistry::definedClasses);
            return Stream.concat(Stream.of(klass), nestedClass);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RelocateClass {
        public String value();
    }
}

