/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.common.typeutils.base.EnumSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class EnumSerializerTest
extends TestLogger {
    @Test
    public void testPublicEnum() {
        this.testEnumSerializer(new PrivateEnum[]{PrivateEnum.ONE, PrivateEnum.TWO, PrivateEnum.THREE});
    }

    @Test
    public void testPrivateEnum() {
        this.testEnumSerializer(new PublicEnum[]{PublicEnum.FOO, PublicEnum.BAR, PublicEnum.PETER, PublicEnum.NATHANIEL, PublicEnum.EMMA, PublicEnum.PAULA});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyEnum() {
        new EnumSerializer(EmptyEnum.class);
    }

    @Test
    public void testReconfiguration() {
        Enum[] mockPreviousOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL};
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        Assert.assertEquals((long)PublicEnum.FOO.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO)).intValue());
        Assert.assertEquals((long)PublicEnum.BAR.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR)).intValue());
        Assert.assertEquals((long)PublicEnum.PETER.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER)).intValue());
        Assert.assertEquals((long)PublicEnum.NATHANIEL.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL)).intValue());
        Assert.assertEquals((long)PublicEnum.EMMA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA)).intValue());
        Assert.assertEquals((long)PublicEnum.PAULA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA)).intValue());
        EnumSerializer.EnumSerializerSnapshot serializerSnapshot = new EnumSerializer.EnumSerializerSnapshot(PublicEnum.class, mockPreviousOrder);
        TypeSerializerSchemaCompatibility compatibility = serializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)serializerSnapshot);
        Assert.assertTrue((boolean)compatibility.isCompatibleWithReconfiguredSerializer());
        PublicEnum[] expectedOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL, PublicEnum.FOO, PublicEnum.PETER, PublicEnum.EMMA};
        EnumSerializer configuredSerializer = (EnumSerializer)compatibility.getReconfiguredSerializer();
        int i = 0;
        for (PublicEnum constant : expectedOrder) {
            Assert.assertEquals((long)i, (long)((Integer)configuredSerializer.getValueToOrdinal().get((Object)constant)).intValue());
            ++i;
        }
        Assert.assertTrue((boolean)Arrays.equals((Object[])expectedOrder, configuredSerializer.getValues()));
    }

    @Test
    public void testConfigurationSnapshotSerialization() throws Exception {
        TypeSerializerSnapshot restoredConfig;
        byte[] serializedConfig;
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)serializer.snapshotConfiguration());
            serializedConfig = out.toByteArray();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            restoredConfig = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility compatResult = serializer.snapshotConfiguration().resolveSchemaCompatibility(restoredConfig);
        Assert.assertTrue((boolean)compatResult.isCompatibleAsIs());
        Assert.assertEquals((long)PublicEnum.FOO.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO)).intValue());
        Assert.assertEquals((long)PublicEnum.BAR.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR)).intValue());
        Assert.assertEquals((long)PublicEnum.PETER.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER)).intValue());
        Assert.assertEquals((long)PublicEnum.NATHANIEL.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL)).intValue());
        Assert.assertEquals((long)PublicEnum.EMMA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA)).intValue());
        Assert.assertEquals((long)PublicEnum.PAULA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA)).intValue());
        Assert.assertTrue((boolean)Arrays.equals((Object[])PublicEnum.values(), serializer.getValues()));
    }

    @Test
    public void testSerializeEnumSerializer() throws Exception {
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        Assert.assertEquals((long)PublicEnum.FOO.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO)).intValue());
        Assert.assertEquals((long)PublicEnum.BAR.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR)).intValue());
        Assert.assertEquals((long)PublicEnum.PETER.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER)).intValue());
        Assert.assertEquals((long)PublicEnum.NATHANIEL.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL)).intValue());
        Assert.assertEquals((long)PublicEnum.EMMA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA)).intValue());
        Assert.assertEquals((long)PublicEnum.PAULA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA)).intValue());
        Assert.assertTrue((boolean)Arrays.equals((Object[])PublicEnum.values(), serializer.getValues()));
        byte[] serializedSerializer = InstantiationUtil.serializeObject((Object)serializer);
        serializer = (EnumSerializer)InstantiationUtil.deserializeObject((byte[])serializedSerializer, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((long)PublicEnum.FOO.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO)).intValue());
        Assert.assertEquals((long)PublicEnum.BAR.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR)).intValue());
        Assert.assertEquals((long)PublicEnum.PETER.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER)).intValue());
        Assert.assertEquals((long)PublicEnum.NATHANIEL.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL)).intValue());
        Assert.assertEquals((long)PublicEnum.EMMA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA)).intValue());
        Assert.assertEquals((long)PublicEnum.PAULA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA)).intValue());
        Assert.assertTrue((boolean)Arrays.equals((Object[])PublicEnum.values(), serializer.getValues()));
    }

    @Test
    public void testSerializeReconfiguredEnumSerializer() throws Exception {
        Enum[] mockPreviousOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL};
        EnumSerializer serializer = new EnumSerializer(PublicEnum.class);
        Assert.assertEquals((long)PublicEnum.FOO.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.FOO)).intValue());
        Assert.assertEquals((long)PublicEnum.BAR.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.BAR)).intValue());
        Assert.assertEquals((long)PublicEnum.PETER.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PETER)).intValue());
        Assert.assertEquals((long)PublicEnum.NATHANIEL.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.NATHANIEL)).intValue());
        Assert.assertEquals((long)PublicEnum.EMMA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.EMMA)).intValue());
        Assert.assertEquals((long)PublicEnum.PAULA.ordinal(), (long)((Integer)serializer.getValueToOrdinal().get((Object)PublicEnum.PAULA)).intValue());
        EnumSerializer.EnumSerializerSnapshot serializerSnapshot = new EnumSerializer.EnumSerializerSnapshot(PublicEnum.class, mockPreviousOrder);
        TypeSerializerSchemaCompatibility compatibility = serializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)serializerSnapshot);
        Assert.assertTrue((boolean)compatibility.isCompatibleWithReconfiguredSerializer());
        PublicEnum[] expectedOrder = new PublicEnum[]{PublicEnum.BAR, PublicEnum.PAULA, PublicEnum.NATHANIEL, PublicEnum.FOO, PublicEnum.PETER, PublicEnum.EMMA};
        EnumSerializer configuredSerializer = (EnumSerializer)compatibility.getReconfiguredSerializer();
        int i = 0;
        for (PublicEnum constant : expectedOrder) {
            Assert.assertEquals((long)i, (long)((Integer)configuredSerializer.getValueToOrdinal().get((Object)constant)).intValue());
            ++i;
        }
        Assert.assertTrue((boolean)Arrays.equals((Object[])expectedOrder, configuredSerializer.getValues()));
    }

    @SafeVarargs
    public final <T extends Enum<T>> void testEnumSerializer(T ... data) {
        Class<?> clazz = data.getClass().getComponentType();
        SerializerTestInstance tester = new SerializerTestInstance<T>((TypeSerializer)new EnumSerializer(clazz), (Class)clazz, 4, (Enum[])data){};
        tester.testAll();
    }

    private static enum PrivateEnum {
        ONE,
        TWO,
        THREE;

    }

    public static enum EmptyEnum {

    }

    public static enum PublicEnum {
        FOO,
        BAR,
        PETER,
        NATHANIEL,
        EMMA,
        PAULA;

    }
}

