/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.Random;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.FloatValueComparator;
import org.apache.flink.api.common.typeutils.base.FloatValueSerializer;
import org.apache.flink.types.FloatValue;

class FloatValueComparatorTest
extends ComparatorTestBase<FloatValue> {
    FloatValueComparatorTest() {
    }

    @Override
    protected TypeComparator<FloatValue> createComparator(boolean ascending) {
        return new FloatValueComparator(ascending);
    }

    @Override
    protected TypeSerializer<FloatValue> createSerializer() {
        return new FloatValueSerializer();
    }

    protected FloatValue[] getSortedTestData() {
        Random rnd = new Random(874597969123412338L);
        float rndFloat = rnd.nextFloat();
        if (rndFloat < 0.0f) {
            rndFloat = -rndFloat;
        }
        if (rndFloat == Float.MAX_VALUE) {
            rndFloat -= 3.0f;
        }
        if (rndFloat <= 2.0f) {
            rndFloat += 3.0f;
        }
        return new FloatValue[]{new FloatValue(-rndFloat), new FloatValue(-1.0f), new FloatValue(0.0f), new FloatValue(2.0f), new FloatValue(rndFloat), new FloatValue(Float.MAX_VALUE)};
    }
}

