/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.mocks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.mocks.MockSourceReader;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.api.connector.source.mocks.MockSourceSplitSerializer;
import org.apache.flink.api.connector.source.mocks.MockSplitEnumerator;
import org.apache.flink.api.connector.source.mocks.MockSplitEnumeratorCheckpointSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class MockSource
implements Source<Integer, MockSourceSplit, Set<MockSourceSplit>> {
    private static final long serialVersionUID = 1L;
    private final Boundedness boundedness;
    private final int numSplits;
    private final MockSourceReader.WaitingForSplits readerWaitingForMoreSplits;
    private final boolean readerMarkIdleOnNoSplits;
    protected List<MockSourceReader> createdReaders;

    public MockSource(Boundedness boundedness, int numSplits) {
        this(boundedness, numSplits, false, false);
    }

    public MockSource(Boundedness boundedness, int numSplits, boolean readerWaitingForMoreSplits, boolean readerMarkIdleOnNoSplits) {
        this(boundedness, numSplits, readerWaitingForMoreSplits ? MockSourceReader.WaitingForSplits.WAIT_UNTIL_ALL_SPLITS_ASSIGNED : MockSourceReader.WaitingForSplits.DO_NOT_WAIT_FOR_SPLITS, readerMarkIdleOnNoSplits);
    }

    private MockSource(Boundedness boundedness, int numSplits, MockSourceReader.WaitingForSplits readerWaitingForSplitsBehaviour, boolean readerMarkIdleOnNoSplits) {
        this.boundedness = boundedness;
        this.numSplits = numSplits;
        this.createdReaders = new ArrayList<MockSourceReader>();
        this.readerWaitingForMoreSplits = readerWaitingForSplitsBehaviour;
        this.readerMarkIdleOnNoSplits = readerMarkIdleOnNoSplits;
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public SourceReader<Integer, MockSourceSplit> createReader(SourceReaderContext readerContext) {
        MockSourceReader mockSourceReader = new MockSourceReader(this.readerWaitingForMoreSplits, this.readerMarkIdleOnNoSplits);
        this.createdReaders.add(mockSourceReader);
        return mockSourceReader;
    }

    public SplitEnumerator<MockSourceSplit, Set<MockSourceSplit>> createEnumerator(SplitEnumeratorContext<MockSourceSplit> enumContext) {
        return new MockSplitEnumerator(this.numSplits, enumContext);
    }

    public SplitEnumerator<MockSourceSplit, Set<MockSourceSplit>> restoreEnumerator(SplitEnumeratorContext<MockSourceSplit> enumContext, Set<MockSourceSplit> checkpoint) throws IOException {
        return new MockSplitEnumerator(checkpoint, enumContext);
    }

    public SimpleVersionedSerializer<MockSourceSplit> getSplitSerializer() {
        return new MockSourceSplitSerializer();
    }

    public SimpleVersionedSerializer<Set<MockSourceSplit>> getEnumeratorCheckpointSerializer() {
        return new MockSplitEnumeratorCheckpointSerializer();
    }

    public static Builder continuous(int numSplits) {
        return new Builder(Boundedness.CONTINUOUS_UNBOUNDED, numSplits);
    }

    public static Builder bounded(int numSplits) {
        return new Builder(Boundedness.BOUNDED, numSplits);
    }

    public List<MockSourceReader> getCreatedReaders() {
        return this.createdReaders;
    }

    public static class Builder {
        private final Boundedness boundedness;
        private final int numSplits;
        private MockSourceReader.WaitingForSplits readerWaitingForSplitsBehaviour = MockSourceReader.WaitingForSplits.WAIT_FOR_INITIAL;
        private boolean readerMarkIdleOnNoSplits = true;

        private Builder(Boundedness boundedness, int numSplits) {
            this.boundedness = boundedness;
            this.numSplits = numSplits;
        }

        public Builder waitOnlyForInitialSplits() {
            this.readerWaitingForSplitsBehaviour = MockSourceReader.WaitingForSplits.WAIT_FOR_INITIAL;
            return this;
        }

        public Builder waitUntilAllSplitsAssigned() {
            this.readerWaitingForSplitsBehaviour = MockSourceReader.WaitingForSplits.WAIT_UNTIL_ALL_SPLITS_ASSIGNED;
            return this;
        }

        public Builder doNotWaitForSplitsAssignment() {
            this.readerWaitingForSplitsBehaviour = MockSourceReader.WaitingForSplits.DO_NOT_WAIT_FOR_SPLITS;
            return this;
        }

        public Builder markReaderIdleOnNoSplits(boolean enable) {
            this.readerMarkIdleOnNoSplits = enable;
            return this;
        }

        public MockSource build() {
            return new MockSource(this.boundedness, this.numSplits, this.readerWaitingForSplitsBehaviour, this.readerMarkIdleOnNoSplits);
        }
    }
}

