/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.mocks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;

public class MockSplitEnumerator
implements SplitEnumerator<MockSourceSplit, Set<MockSourceSplit>> {
    private final SortedSet<MockSourceSplit> unassignedSplits = new TreeSet<MockSourceSplit>(Comparator.comparingInt(o -> Integer.parseInt(o.splitId())));
    private final SplitEnumeratorContext<MockSourceSplit> enumContext;
    private final List<SourceEvent> handledSourceEvent;
    private final List<Long> successfulCheckpoints;
    private volatile boolean started;
    private volatile boolean closed;

    public MockSplitEnumerator(int numSplits, SplitEnumeratorContext<MockSourceSplit> enumContext) {
        this(new HashSet<MockSourceSplit>(), enumContext);
        for (int i = 0; i < numSplits; ++i) {
            this.unassignedSplits.add(new MockSourceSplit(i));
        }
    }

    public MockSplitEnumerator(Set<MockSourceSplit> unassignedSplits, SplitEnumeratorContext<MockSourceSplit> enumContext) {
        this.unassignedSplits.addAll(unassignedSplits);
        this.enumContext = enumContext;
        this.handledSourceEvent = new ArrayList<SourceEvent>();
        this.successfulCheckpoints = new ArrayList<Long>();
        this.started = false;
        this.closed = false;
    }

    public void start() {
        this.started = true;
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        this.handledSourceEvent.add(sourceEvent);
    }

    public void addSplitsBack(List<MockSourceSplit> splits, int subtaskId) {
        this.unassignedSplits.addAll(splits);
    }

    public void addReader(int subtaskId) {
        ArrayList<MockSourceSplit> assignment = new ArrayList<MockSourceSplit>();
        for (MockSourceSplit split : this.unassignedSplits) {
            if (Integer.parseInt(split.splitId()) % this.enumContext.currentParallelism() != subtaskId) continue;
            assignment.add(split);
        }
        this.enumContext.assignSplits(new SplitsAssignment(Collections.singletonMap(subtaskId, assignment)));
        this.unassignedSplits.removeAll(assignment);
    }

    public Set<MockSourceSplit> snapshotState(long checkpointId) {
        return this.unassignedSplits;
    }

    public void notifyCheckpointComplete(long checkpointId) {
        this.successfulCheckpoints.add(checkpointId);
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public void addNewSplits(List<MockSourceSplit> newSplits) {
        this.unassignedSplits.addAll(newSplits);
        this.assignAllSplits();
    }

    public boolean started() {
        return this.started;
    }

    public boolean closed() {
        return this.closed;
    }

    public Set<MockSourceSplit> getUnassignedSplits() {
        return this.unassignedSplits;
    }

    public List<SourceEvent> getHandledSourceEvent() {
        return this.handledSourceEvent;
    }

    public List<Long> getSuccessfulCheckpoints() {
        return this.successfulCheckpoints;
    }

    private void assignAllSplits() {
        HashMap assignment = new HashMap();
        this.unassignedSplits.forEach(split -> {
            int subtaskId = Integer.parseInt(split.splitId()) % this.enumContext.currentParallelism();
            if (this.enumContext.registeredReaders().containsKey(subtaskId)) {
                assignment.computeIfAbsent(subtaskId, ignored -> new ArrayList()).add(split);
            }
        });
        this.enumContext.assignSplits(new SplitsAssignment(assignment));
        assignment.values().forEach(l -> this.unassignedSplits.removeAll((Collection<?>)l));
    }
}

