/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.HashMap;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PojoParametrizedTypeExtractionTest {
    @Test
    public void testDirectlyCreateTypeInfo() {
        TypeInformation directTypeInfo = TypeExtractor.createTypeInfo(ParameterizedParentImpl.class);
        Assert.assertThat((Object)directTypeInfo, (Matcher)CoreMatchers.equalTo(this.getParameterizedParentTypeInformation()));
    }

    @Test
    public void testMapReturnTypeInfo() {
        TypeInformation<ParameterizedParentImpl> expectedTypeInfo = this.getParameterizedParentTypeInformation();
        TypeInformation mapReturnTypeInfo = TypeExtractor.getMapReturnTypes((MapFunction)new ConcreteMapFunction(), (TypeInformation)Types.INT);
        Assert.assertThat((Object)mapReturnTypeInfo, (Matcher)CoreMatchers.equalTo(expectedTypeInfo));
    }

    private TypeInformation<ParameterizedParentImpl> getParameterizedParentTypeInformation() {
        HashMap<String, TypeInformation> nestedFields = new HashMap<String, TypeInformation>();
        nestedFields.put("digits", Types.INT);
        nestedFields.put("letters", Types.STRING);
        HashMap<String, TypeInformation> fields = new HashMap<String, TypeInformation>();
        fields.put("precise", Types.DOUBLE);
        fields.put("pojoField", Types.POJO(Pojo.class, nestedFields));
        return Types.POJO(ParameterizedParentImpl.class, fields);
    }

    public static class ConcreteMapFunction
    implements MapFunction<Integer, ParameterizedParentImpl> {
        public ParameterizedParentImpl map(Integer value) throws Exception {
            return null;
        }
    }

    public static class ParameterizedParentImpl
    extends ParameterizedParent<Pojo> {
        public double precise;
    }

    public static class ParameterizedParent<T> {
        public T pojoField;
    }

    public static class Pojo {
        public int digits;
        public String letters;
    }
}

