/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeInformationTestBase;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RowTypeInfoTest
extends TypeInformationTestBase<RowTypeInfo> {
    private static TypeInformation<?>[] typeList = new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.SHORT_TYPE_INFO, BasicTypeInfo.BIG_DEC_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO};

    RowTypeInfoTest() {
    }

    protected RowTypeInfo[] getTestData() {
        return new RowTypeInfo[]{new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO}), new RowTypeInfo(typeList), new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO}, new String[]{"int", "int2"})};
    }

    @Test
    void testWrongNumberOfFieldNames() {
        Assertions.assertThatThrownBy(() -> new RowTypeInfo(typeList, new String[]{"int", "string"})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDuplicateCustomFieldNames() {
        Assertions.assertThatThrownBy(() -> new RowTypeInfo(typeList, new String[]{"int", "string", "string"})).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testCustomFieldNames() {
        String[] fieldNames = new String[]{"int", "row", "string"};
        RowTypeInfo typeInfo1 = new RowTypeInfo(typeList, new String[]{"int", "row", "string"});
        Assertions.assertThat((Object[])typeInfo1.getFieldNames()).isEqualTo((Object)new String[]{"int", "row", "string"});
        Assertions.assertThat((Object)typeInfo1.getTypeAt("string")).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)typeInfo1.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)typeInfo1.getTypeAt("row.0")).isEqualTo((Object)BasicTypeInfo.SHORT_TYPE_INFO);
        Assertions.assertThat((Object)typeInfo1.getTypeAt("row.f1")).isEqualTo((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO);
        fieldNames[1] = "composite";
        RowTypeInfo typeInfo2 = new RowTypeInfo(typeList, fieldNames);
        Assertions.assertThat((Object[])typeInfo1.getFieldNames()).isEqualTo((Object)new String[]{"int", "row", "string"});
        Assertions.assertThat((Object[])typeInfo2.getFieldNames()).isEqualTo((Object)new String[]{"int", "composite", "string"});
    }

    @Test
    void testGetFlatFields() {
        RowTypeInfo typeInfo1 = new RowTypeInfo(typeList, new String[]{"int", "row", "string"});
        ArrayList result = new ArrayList();
        typeInfo1.getFlatFields("row.*", 0, result);
        Assertions.assertThat(result).hasSize(2);
        Assertions.assertThat((String)((CompositeType.FlatFieldDescriptor)result.get(0)).toString()).isEqualTo(new CompositeType.FlatFieldDescriptor(1, (TypeInformation)BasicTypeInfo.SHORT_TYPE_INFO).toString());
        Assertions.assertThat((String)((CompositeType.FlatFieldDescriptor)result.get(1)).toString()).isEqualTo(new CompositeType.FlatFieldDescriptor(2, (TypeInformation)BasicTypeInfo.BIG_DEC_TYPE_INFO).toString());
        result.clear();
        typeInfo1.getFlatFields("string", 0, result);
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat((String)((CompositeType.FlatFieldDescriptor)result.get(0)).toString()).isEqualTo(new CompositeType.FlatFieldDescriptor(3, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO).toString());
    }

    @Test
    void testGetTypeAt() {
        RowTypeInfo typeInfo = new RowTypeInfo(typeList);
        Assertions.assertThat((Object[])typeInfo.getFieldNames()).isEqualTo((Object)new String[]{"f0", "f1", "f2"});
        Assertions.assertThat((Object)typeInfo.getTypeAt("f2")).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)typeInfo.getTypeAt("f1.f0")).isEqualTo((Object)BasicTypeInfo.SHORT_TYPE_INFO);
        Assertions.assertThat((Object)typeInfo.getTypeAt("f1.1")).isEqualTo((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO);
    }

    @Test
    void testNestedRowTypeInfo() {
        RowTypeInfo typeInfo = new RowTypeInfo(typeList);
        Assertions.assertThat((String)typeInfo.getTypeAt("f1").toString()).isEqualTo("Row(f0: Short, f1: BigDecimal)");
        Assertions.assertThat((String)typeInfo.getTypeAt("f1.f0").toString()).isEqualTo("Short");
    }

    @Test
    void testSchemaEquals() {
        RowTypeInfo row1 = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}, new String[]{"field1", "field2"});
        RowTypeInfo row2 = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}, new String[]{"field1", "field2"});
        Assertions.assertThat((boolean)row1.schemaEquals((Object)row2)).isTrue();
        RowTypeInfo other1 = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}, new String[]{"otherField", "field2"});
        RowTypeInfo other2 = new RowTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}, new String[]{"field1", "field2"});
        Assertions.assertThat((boolean)row1.schemaEquals((Object)other1)).isFalse();
        Assertions.assertThat((boolean)row1.schemaEquals((Object)other2)).isFalse();
    }
}

