/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.YamlParserUtils;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;

class YamlParserUtilsTest {
    @TempDir
    private File tmpDir;

    YamlParserUtilsTest() {
    }

    @Test
    void testLoadYamlFile() throws Exception {
        File confFile = new File(this.tmpDir, "test.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.println("key1: value1");
            pw.println("key2: ");
            pw.println("  subKey1: value2");
            pw.println("key3: [a, b, c]");
            pw.println("key4: {k1: v1, k2: v2, k3: v3}");
            pw.println("key5: '*'");
            pw.println("key6: true");
            pw.println("key7: 'true'");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        Map yamlData = YamlParserUtils.loadYamlFile((File)confFile);
        Assertions.assertThat((Map)yamlData).isNotNull();
        Assertions.assertThat(yamlData.get("key1")).isEqualTo((Object)"value1");
        Assertions.assertThat(((Map)yamlData.get("key2")).get("subKey1")).isEqualTo((Object)"value2");
        Assertions.assertThat(yamlData.get("key3")).isEqualTo(Arrays.asList("a", "b", "c"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        map.put("k2", "v2");
        map.put("k3", "v3");
        Assertions.assertThat(yamlData.get("key4")).isEqualTo(map);
        Assertions.assertThat(yamlData.get("key5")).isEqualTo((Object)"*");
        Assertions.assertThat((Boolean)((Boolean)yamlData.get("key6"))).isTrue();
        Assertions.assertThat(yamlData.get("key7")).isEqualTo((Object)"true");
    }

    @Test
    void testYaml12Features() {
        String booleanRepresentation = "key1: Yes\nkey2: y\nkey3: on";
        HashMap<String, String> expectedBooleanRepresentation = new HashMap<String, String>();
        expectedBooleanRepresentation.put("key1", "Yes");
        expectedBooleanRepresentation.put("key2", "y");
        expectedBooleanRepresentation.put("key3", "on");
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)booleanRepresentation, Map.class))).containsAllEntriesOf(expectedBooleanRepresentation);
        String underlineInNumber = "key1: 1_000";
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)underlineInNumber, Map.class))).containsEntry((Object)"key1", (Object)"1_000");
        String octalNumber1 = "octal: 010";
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)octalNumber1, Map.class))).containsEntry((Object)"octal", (Object)10);
        String octalNumber2 = "octal: 0o10";
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)octalNumber2, Map.class))).containsEntry((Object)"octal", (Object)8);
        String binaryNumber = "binary: 0b101";
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)binaryNumber, Map.class))).containsEntry((Object)"binary", (Object)"0b101");
        String sexagesimalNumber = "sexagesimal: 1:00";
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)sexagesimalNumber, Map.class))).containsEntry((Object)"sexagesimal", (Object)"1:00");
        String timestamp = "!!timestamp 2001-12-15T02:59:43.1Z";
        Assertions.assertThatThrownBy(() -> YamlParserUtils.convertToObject((String)timestamp, Object.class)).isInstanceOf(YamlEngineException.class);
    }

    @Test
    void testLoadEmptyYamlFile() throws Exception {
        File confFile = new File(this.tmpDir, "test.yaml");
        confFile.createNewFile();
        Assertions.assertThat((Map)YamlParserUtils.loadYamlFile((File)confFile)).isEmpty();
    }

    @Test
    void testLoadYamlFile_InvalidYAMLSyntaxException() {
        File confFile = new File(this.tmpDir, "invalid.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.println("key: value: secret");
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> YamlParserUtils.loadYamlFile((File)confFile)).isInstanceOf(YamlEngineException.class)).satisfies(new ThrowingConsumer[]{e -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)e)).doesNotContain(new CharSequence[]{"secret"});
        }});
    }

    @Test
    void testLoadYamlFile_DuplicateKeyException() {
        File confFile = new File(this.tmpDir, "invalid.yaml");
        try (PrintWriter pw = new PrintWriter(confFile);){
            pw.println("key: secret1");
            pw.println("key: secret2");
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> YamlParserUtils.loadYamlFile((File)confFile)).isInstanceOf(YamlEngineException.class)).satisfies(new ThrowingConsumer[]{e -> {
            AbstractStringAssert cfr_ignored_0 = (AbstractStringAssert)Assertions.assertThat((String)ExceptionUtils.stringifyException((Throwable)e)).doesNotContain(new CharSequence[]{"secret1", "secret2"});
        }});
    }

    @Test
    void testToYAMLString() {
        Assertions.assertThat((String)YamlParserUtils.toYAMLString((Object)((Object)TestEnum.ENUM))).isEqualTo(TestEnum.ENUM.toString());
        Integer o1 = 123;
        Assertions.assertThat((String)YamlParserUtils.toYAMLString((Object)o1)).isEqualTo(String.valueOf(o1));
        Boolean o2 = true;
        Assertions.assertThat((String)YamlParserUtils.toYAMLString((Object)o2)).isEqualTo(String.valueOf(o2));
        List<String> o3 = Arrays.asList("*", "123", "true");
        Assertions.assertThat((String)YamlParserUtils.toYAMLString(o3)).isEqualTo("['*', '123', 'true']");
    }

    @Test
    void testConvertToObject() {
        String s1 = "test";
        Assertions.assertThat((String)((String)YamlParserUtils.convertToObject((String)s1, String.class))).isEqualTo(s1);
        String s2 = "true";
        Assertions.assertThat((Boolean)((Boolean)YamlParserUtils.convertToObject((String)s2, Boolean.class))).isTrue();
        String s3 = "[a, b, c]";
        Assertions.assertThat((List)((List)YamlParserUtils.convertToObject((String)s3, List.class))).isEqualTo(Arrays.asList("a", "b", "c"));
        String s4 = "{k1: v1, k2: v2}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        map.put("k2", "v2");
        Assertions.assertThat((Map)((Map)YamlParserUtils.convertToObject((String)s4, Map.class))).isEqualTo(map);
    }

    @Test
    void testDumpNestedYamlFromFlatMap() {
        HashMap<String, Object> flattenMap = new HashMap<String, Object>();
        flattenMap.put("string", "stringValue");
        flattenMap.put("integer", 42);
        flattenMap.put("double", 3.14);
        flattenMap.put("boolean", true);
        flattenMap.put("enum", (Object)TestEnum.ENUM);
        flattenMap.put("list1", Arrays.asList("item1", "item2", "item3"));
        flattenMap.put("list2", "{item1, item2, item3}");
        flattenMap.put("map1", Collections.singletonMap("k1", "v1"));
        flattenMap.put("map2", "{k2: v2}");
        flattenMap.put("listMap1", Arrays.asList(Collections.singletonMap("k3", "v3"), Collections.singletonMap("k4", "v4")));
        flattenMap.put("listMap2", "[{k5: v5}, {k6: v6}]");
        flattenMap.put("nested.key1.subKey1", "value1");
        flattenMap.put("nested.key2.subKey1", "value2");
        flattenMap.put("nested.key3", "value3");
        flattenMap.put("escaped1", "*");
        flattenMap.put("escaped2", "1");
        flattenMap.put("escaped3", "true");
        List values = YamlParserUtils.convertAndDumpYamlFromFlatMap(flattenMap);
        Assertions.assertThat((List)values).containsExactlyInAnyOrder((Object[])new String[]{"string: stringValue", "integer: 42", "double: 3.14", "boolean: true", "enum: ENUM", "list1:", "- item1", "- item2", "- item3", "list2: '{item1, item2, item3}'", "map1:", "  k1: v1", "map2: '{k2: v2}'", "listMap1:", "- k3: v3", "- k4: v4", "listMap2: '[{k5: v5}, {k6: v6}]'", "nested:", "  key1:", "    subKey1: value1", "  key2:", "    subKey1: value2", "  key3: value3", "escaped1: '*'", "escaped2: '1'", "escaped3: 'true'"});
    }

    private static enum TestEnum {
        ENUM;

    }
}

