/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.core.fs.AutoCloseableRegistry;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class AutoCloseableRegistryTest
extends TestLogger {
    @Test
    public void testReverseOrderOfClosing() throws Exception {
        ArrayList closeOrder = new ArrayList();
        AutoCloseableRegistry autoCloseableRegistry = new AutoCloseableRegistry();
        autoCloseableRegistry.registerCloseable(() -> closeOrder.add(3));
        autoCloseableRegistry.registerCloseable(() -> closeOrder.add(2));
        autoCloseableRegistry.registerCloseable(() -> closeOrder.add(1));
        autoCloseableRegistry.close();
        int expected = 1;
        Iterator iterator = closeOrder.iterator();
        while (iterator.hasNext()) {
            int actual = (Integer)iterator.next();
            Assert.assertEquals((long)expected++, (long)actual);
        }
    }

    @Test
    public void testSuppressedExceptions() throws Exception {
        AutoCloseableRegistry autoCloseableRegistry = new AutoCloseableRegistry();
        autoCloseableRegistry.registerCloseable(() -> {
            throw new AssertionError((Object)"3");
        });
        autoCloseableRegistry.registerCloseable(() -> {
            throw new Exception("2");
        });
        autoCloseableRegistry.registerCloseable(() -> {
            throw new Exception("1");
        });
        try {
            autoCloseableRegistry.close();
            Assert.fail((String)"Close should throw exception");
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"1", (Object)ex.getMessage());
            Assert.assertEquals((Object)"2", (Object)ex.getSuppressed()[0].getMessage());
            Assert.assertEquals((Object)"java.lang.AssertionError: 3", (Object)ex.getSuppressed()[1].getMessage());
        }
    }
}

