/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.fs.AbstractAutoCloseableRegistryTest;
import org.apache.flink.core.fs.ClosingFSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.core.fs.WrappingProxyCloseable;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.util.AbstractAutoCloseableRegistry;
import org.apache.flink.util.ExceptionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SafetyNetCloseableRegistryTest
extends AbstractAutoCloseableRegistryTest<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef> {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Override
    protected void registerCloseable(final Closeable closeable) throws IOException {
        WrappingProxyCloseable<Closeable> wrappingProxyCloseable = new WrappingProxyCloseable<Closeable>(){

            public void close() throws IOException {
                closeable.close();
            }

            public Closeable getWrappedDelegate() {
                return closeable;
            }
        };
        this.closeableRegistry.registerCloseable((AutoCloseable)wrappingProxyCloseable);
    }

    @Override
    protected AbstractAutoCloseableRegistry<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef, IOException> createRegistry() {
        return new SafetyNetCloseableRegistry(() -> new JoinOnInterruptReaperThread());
    }

    @Override
    protected AbstractAutoCloseableRegistryTest.ProducerThread<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef> createProducerThread(AbstractAutoCloseableRegistry<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef, IOException> registry, AtomicInteger unclosedCounter, int maxStreams) {
        return new AbstractAutoCloseableRegistryTest.ProducerThread<Closeable, WrappingProxyCloseable<? extends Closeable>, SafetyNetCloseableRegistry.PhantomDelegatingCloseableRef>(registry, unclosedCounter, maxStreams){
            int count;
            {
                this.count = 0;
            }

            @Override
            protected void createAndRegisterStream() throws IOException {
                String debug = Thread.currentThread().getName() + " " + this.count;
                AbstractAutoCloseableRegistryTest.TestStream testStream = new AbstractAutoCloseableRegistryTest.TestStream(this.refCount);
                ClosingFSDataInputStream pis = ClosingFSDataInputStream.wrapSafe((FSDataInputStream)testStream, (SafetyNetCloseableRegistry)((SafetyNetCloseableRegistry)this.registry), (String)debug);
                ++this.count;
            }
        };
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
    }

    @Test
    public void testCorrectScopesForSafetyNet() throws Exception {
        CheckedThread t1 = new CheckedThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void go() throws Exception {
                try {
                    FileSystem fs1 = FileSystem.getLocalFileSystem();
                    Assert.assertFalse((boolean)(fs1 instanceof SafetyNetWrapperFileSystem));
                    FileSystemSafetyNet.initializeSafetyNetForThread();
                    fs1 = FileSystem.getLocalFileSystem();
                    Assert.assertTrue((boolean)(fs1 instanceof SafetyNetWrapperFileSystem));
                    Path tmp = new Path(SafetyNetCloseableRegistryTest.this.tmpFolder.newFolder().toURI().toString(), "test_file");
                    try (FSDataOutputStream stream = fs1.create(tmp, FileSystem.WriteMode.NO_OVERWRITE);){
                        CheckedThread t2 = new CheckedThread(){

                            public void go() {
                                FileSystem fs2 = FileSystem.getLocalFileSystem();
                                Assert.assertFalse((boolean)(fs2 instanceof SafetyNetWrapperFileSystem));
                                FileSystemSafetyNet.initializeSafetyNetForThread();
                                fs2 = FileSystem.getLocalFileSystem();
                                Assert.assertTrue((boolean)(fs2 instanceof SafetyNetWrapperFileSystem));
                                FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                                fs2 = FileSystem.getLocalFileSystem();
                                Assert.assertFalse((boolean)(fs2 instanceof SafetyNetWrapperFileSystem));
                            }
                        };
                        t2.start();
                        t2.sync();
                        stream.write(42);
                        FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                        try {
                            stream.write(43);
                            Assert.fail();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        fs1 = FileSystem.getLocalFileSystem();
                        Assert.assertFalse((boolean)(fs1 instanceof SafetyNetWrapperFileSystem));
                    }
                    finally {
                        fs1.delete(tmp, false);
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)ExceptionUtils.stringifyException((Throwable)e));
                }
            }
        };
        t1.start();
        t1.sync();
    }

    @Test
    public void testSafetyNetClose() throws Exception {
        this.setup(20);
        this.startThreads();
        this.joinThreads();
        for (int i = 0; i < 5 && this.unclosedCounter.get() > 0; ++i) {
            System.gc();
            Thread.sleep(50L);
        }
        Assert.assertEquals((long)0L, (long)this.unclosedCounter.get());
        this.closeableRegistry.close();
    }

    @Test
    public void testReaperThreadSpawnAndStop() throws Exception {
        Assert.assertFalse((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
        try (SafetyNetCloseableRegistry ignored = new SafetyNetCloseableRegistry();){
            Assert.assertTrue((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
            try (SafetyNetCloseableRegistry ignored2 = new SafetyNetCloseableRegistry();){
                Assert.assertTrue((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
            }
            Assert.assertTrue((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
        }
        Assert.assertFalse((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
    }

    @Test
    public void testReaperThreadStartFailed() throws Exception {
        try {
            new SafetyNetCloseableRegistry(() -> new OutOfMemoryReaperThread());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Assert.assertFalse((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
        SafetyNetCloseableRegistry closeableRegistry = new SafetyNetCloseableRegistry();
        Assert.assertTrue((boolean)SafetyNetCloseableRegistry.isReaperThreadRunning());
        closeableRegistry.close();
    }

    private static class OutOfMemoryReaperThread
    extends SafetyNetCloseableRegistry.CloseableReaperThread {
        private OutOfMemoryReaperThread() {
        }

        public synchronized void start() {
            throw new OutOfMemoryError();
        }
    }

    private static class JoinOnInterruptReaperThread
    extends SafetyNetCloseableRegistry.CloseableReaperThread {
        private JoinOnInterruptReaperThread() {
        }

        public void interrupt() {
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

