/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.junit.Assert;
import org.junit.Test;

public class DataInputDeserializerTest {
    @Test
    public void testAvailable() throws Exception {
        byte[] bytes = new byte[]{};
        DataInputDeserializer dis = new DataInputDeserializer(bytes, 0, bytes.length);
        Assert.assertEquals((long)bytes.length, (long)dis.available());
        bytes = new byte[]{1, 2, 3};
        dis = new DataInputDeserializer(bytes, 0, bytes.length);
        Assert.assertEquals((long)bytes.length, (long)dis.available());
        dis.readByte();
        Assert.assertEquals((long)2L, (long)dis.available());
        dis.readByte();
        Assert.assertEquals((long)1L, (long)dis.available());
        dis.readByte();
        Assert.assertEquals((long)0L, (long)dis.available());
        try {
            dis.readByte();
            Assert.fail((String)"Did not throw expected IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)dis.available());
    }

    @Test
    public void testReadWithLenZero() throws IOException {
        byte[] bytes = new byte[]{};
        DataInputDeserializer dis = new DataInputDeserializer(bytes, 0, bytes.length);
        Assert.assertEquals((long)0L, (long)dis.available());
        byte[] bytesForRead = new byte[]{};
        Assert.assertEquals((long)0L, (long)dis.read(bytesForRead, 0, 0));
    }
}

