/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.junit.Assert;
import org.junit.Test;

public class EndiannessAccessChecks {
    @Test
    public void testOnHeapSegment() {
        this.testBigAndLittleEndianAccessUnaligned(MemorySegmentFactory.wrap((byte[])new byte[11111]));
    }

    @Test
    public void testOffHeapSegment() {
        this.testBigAndLittleEndianAccessUnaligned(MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)11111));
    }

    @Test
    public void testOffHeapUnsafeSegment() {
        this.testBigAndLittleEndianAccessUnaligned(MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)11111));
    }

    private void testBigAndLittleEndianAccessUnaligned(MemorySegment segment) {
        int pos;
        int i;
        Random rnd = new Random();
        long seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            long val = rnd.nextLong();
            int n = rnd.nextInt(segment.size() - 7);
            segment.putLongLittleEndian(n, val);
            long r2 = segment.getLongBigEndian(n);
            Assert.assertEquals((long)val, (long)Long.reverseBytes(r2));
            segment.putLongBigEndian(n, val);
            r2 = segment.getLongLittleEndian(n);
            Assert.assertEquals((long)val, (long)Long.reverseBytes(r2));
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            int val = rnd.nextInt();
            pos = rnd.nextInt(segment.size() - 3);
            segment.putIntLittleEndian(pos, val);
            int n = segment.getIntBigEndian(pos);
            Assert.assertEquals((long)val, (long)Integer.reverseBytes(n));
            segment.putIntBigEndian(pos, val);
            n = segment.getIntLittleEndian(pos);
            Assert.assertEquals((long)val, (long)Integer.reverseBytes(n));
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            short val = (short)rnd.nextInt();
            pos = rnd.nextInt(segment.size() - 1);
            segment.putShortLittleEndian(pos, val);
            short s = segment.getShortBigEndian(pos);
            Assert.assertEquals((long)val, (long)Short.reverseBytes(s));
            segment.putShortBigEndian(pos, val);
            s = segment.getShortLittleEndian(pos);
            Assert.assertEquals((long)val, (long)Short.reverseBytes(s));
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            char val = (char)rnd.nextInt();
            pos = rnd.nextInt(segment.size() - 1);
            segment.putCharLittleEndian(pos, val);
            char c = segment.getCharBigEndian(pos);
            Assert.assertEquals((long)val, (long)Character.reverseBytes(c));
            segment.putCharBigEndian(pos, val);
            c = segment.getCharLittleEndian(pos);
            Assert.assertEquals((long)val, (long)Character.reverseBytes(c));
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            float val = rnd.nextFloat();
            pos = rnd.nextInt(segment.size() - 3);
            segment.putFloatLittleEndian(pos, val);
            float f = segment.getFloatBigEndian(pos);
            float reversed = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(f)));
            Assert.assertEquals((float)val, (float)reversed, (float)0.0f);
            segment.putFloatBigEndian(pos, val);
            f = segment.getFloatLittleEndian(pos);
            reversed = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(f)));
            Assert.assertEquals((float)val, (float)reversed, (float)0.0f);
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            double val = rnd.nextDouble();
            int n = rnd.nextInt(segment.size() - 7);
            segment.putDoubleLittleEndian(n, val);
            double r4 = segment.getDoubleBigEndian(n);
            double reversed = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(r4)));
            Assert.assertEquals((double)val, (double)reversed, (double)0.0);
            segment.putDoubleBigEndian(n, val);
            r4 = segment.getDoubleLittleEndian(n);
            reversed = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(r4)));
            Assert.assertEquals((double)val, (double)reversed, (double)0.0);
        }
    }
}

