/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import org.apache.flink.testutils.serialization.types.AsciiStringType;
import org.apache.flink.testutils.serialization.types.BooleanType;
import org.apache.flink.testutils.serialization.types.ByteArrayType;
import org.apache.flink.testutils.serialization.types.ByteSubArrayType;
import org.apache.flink.testutils.serialization.types.ByteType;
import org.apache.flink.testutils.serialization.types.CharType;
import org.apache.flink.testutils.serialization.types.DoubleType;
import org.apache.flink.testutils.serialization.types.FloatType;
import org.apache.flink.testutils.serialization.types.IntType;
import org.apache.flink.testutils.serialization.types.LongType;
import org.apache.flink.testutils.serialization.types.SerializationTestType;
import org.apache.flink.testutils.serialization.types.ShortType;
import org.apache.flink.testutils.serialization.types.UnsignedByteType;
import org.apache.flink.testutils.serialization.types.UnsignedShortType;

public enum SerializationTestTypeFactory {
    BOOLEAN(new BooleanType()),
    BYTE_ARRAY(new ByteArrayType()),
    BYTE_SUB_ARRAY(new ByteSubArrayType()),
    BYTE(new ByteType()),
    CHAR(new CharType()),
    DOUBLE(new DoubleType()),
    FLOAT(new FloatType()),
    INT(new IntType()),
    LONG(new LongType()),
    SHORT(new ShortType()),
    UNSIGNED_BYTE(new UnsignedByteType()),
    UNSIGNED_SHORT(new UnsignedShortType()),
    STRING(new AsciiStringType());

    private final SerializationTestType factory;

    private SerializationTestTypeFactory(SerializationTestType type) {
        this.factory = type;
    }

    public SerializationTestType factory() {
        return this.factory;
    }
}

