/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Date;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class BasicTypeInfoTest
extends TestLogger {
    static Class<?>[] classes = new Class[]{String.class, Integer.class, Boolean.class, Byte.class, Short.class, Long.class, Float.class, Double.class, Character.class, Date.class, Void.class, BigInteger.class, BigDecimal.class, Instant.class};

    @Test
    public void testBasicTypeInfoEquality() {
        for (Class<?> clazz : classes) {
            BasicTypeInfo tpeInfo1 = BasicTypeInfo.getInfoFor(clazz);
            BasicTypeInfo tpeInfo2 = BasicTypeInfo.getInfoFor(clazz);
            Assert.assertEquals((Object)tpeInfo1, (Object)tpeInfo2);
            Assert.assertEquals((long)tpeInfo1.hashCode(), (long)tpeInfo2.hashCode());
        }
    }

    @Test
    public void testBasicTypeInfoInequality() {
        for (Class<?> clazz1 : classes) {
            for (Class<?> clazz2 : classes) {
                if (clazz1.equals(clazz2)) continue;
                BasicTypeInfo tpeInfo1 = BasicTypeInfo.getInfoFor(clazz1);
                BasicTypeInfo tpeInfo2 = BasicTypeInfo.getInfoFor(clazz2);
                Assert.assertNotEquals((Object)tpeInfo1, (Object)tpeInfo2);
            }
        }
    }
}

