/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AbstractIDTest
extends TestLogger {
    @Test
    public void testSerialization() throws Exception {
        AbstractID origID = new AbstractID();
        AbstractID copyID = (AbstractID)CommonTestUtils.createCopySerializable((Serializable)origID);
        Assert.assertEquals((long)origID.hashCode(), (long)copyID.hashCode());
        Assert.assertEquals((Object)origID, (Object)copyID);
    }

    @Test
    public void testConvertToBytes() throws Exception {
        AbstractID origID = new AbstractID();
        AbstractID copy1 = new AbstractID(origID);
        AbstractID copy2 = new AbstractID(origID.getBytes());
        AbstractID copy3 = new AbstractID(origID.getLowerPart(), origID.getUpperPart());
        Assert.assertEquals((Object)origID, (Object)copy1);
        Assert.assertEquals((Object)origID, (Object)copy2);
        Assert.assertEquals((Object)origID, (Object)copy3);
    }

    @Test
    public void testCompare() throws Exception {
        AbstractID id1 = new AbstractID(0L, 0L);
        AbstractID id2 = new AbstractID(1L, 0L);
        AbstractID id3 = new AbstractID(0L, 1L);
        AbstractID id4 = new AbstractID(-1L, 0L);
        AbstractID id5 = new AbstractID(0L, -1L);
        AbstractID id6 = new AbstractID(-1L, -1L);
        AbstractID id7 = new AbstractID(Long.MAX_VALUE, Long.MAX_VALUE);
        AbstractID id8 = new AbstractID(Long.MIN_VALUE, Long.MIN_VALUE);
        AbstractID id9 = new AbstractID(Long.MAX_VALUE, Long.MIN_VALUE);
        AbstractID id10 = new AbstractID(Long.MIN_VALUE, Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)id1.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id1)));
        Assert.assertEquals((long)0L, (long)id2.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id2)));
        Assert.assertEquals((long)0L, (long)id3.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id3)));
        Assert.assertEquals((long)0L, (long)id4.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id4)));
        Assert.assertEquals((long)0L, (long)id5.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id5)));
        Assert.assertEquals((long)0L, (long)id6.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id6)));
        Assert.assertEquals((long)0L, (long)id7.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id7)));
        Assert.assertEquals((long)0L, (long)id8.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id8)));
        Assert.assertEquals((long)0L, (long)id9.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id9)));
        Assert.assertEquals((long)0L, (long)id10.compareTo((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id10)));
        AbstractIDTest.assertCompare(id1, id2, -1);
        AbstractIDTest.assertCompare(id1, id3, -1);
        AbstractIDTest.assertCompare(id1, id4, 1);
        AbstractIDTest.assertCompare(id1, id5, 1);
        AbstractIDTest.assertCompare(id1, id6, 1);
        AbstractIDTest.assertCompare(id2, id5, 1);
        AbstractIDTest.assertCompare(id3, id5, 1);
        AbstractIDTest.assertCompare(id2, id6, 1);
        AbstractIDTest.assertCompare(id3, id6, 1);
        AbstractIDTest.assertCompare(id1, id7, -1);
        AbstractIDTest.assertCompare(id1, id8, 1);
        AbstractIDTest.assertCompare(id7, id8, 1);
        AbstractIDTest.assertCompare(id9, id10, -1);
        AbstractIDTest.assertCompare(id7, id9, 1);
        AbstractIDTest.assertCompare(id7, id10, 1);
        AbstractIDTest.assertCompare(id8, id9, -1);
        AbstractIDTest.assertCompare(id8, id10, -1);
    }

    @Test
    public void testOldAbstractIDDeserialization() throws Exception {
        long lowerPart = 42L;
        long upperPart = 1337L;
        AbstractID expectedAbstractId = new AbstractID(42L, 1337L);
        String resourceName1 = "abstractID-with-toString-field";
        try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("abstractID-with-toString-field");){
            AbstractID deserializedAbstractId = (AbstractID)InstantiationUtil.deserializeObject((InputStream)resourceAsStream, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Assert.assertThat((Object)deserializedAbstractId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAbstractId)));
        }
        String resourceName2 = "abstractID-with-toString-field-set";
        try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("abstractID-with-toString-field-set");){
            AbstractID deserializedAbstractId = (AbstractID)InstantiationUtil.deserializeObject((InputStream)resourceAsStream, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            Assert.assertThat((Object)deserializedAbstractId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedAbstractId)));
        }
    }

    private static void assertCompare(AbstractID a, AbstractID b, int signum) {
        int sgnAB;
        int cmpAB = a.compareTo(b);
        int cmpBA = b.compareTo(a);
        int n = cmpAB > 0 ? 1 : (sgnAB = cmpAB < 0 ? -1 : 0);
        int sgnBA = cmpBA > 0 ? 1 : (cmpBA < 0 ? -1 : 0);
        Assert.assertEquals((long)signum, (long)sgnAB);
        Assert.assertTrue((sgnAB == -sgnBA ? 1 : 0) != 0);
    }
}

