/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.flink.util.ClassLoaderUtil;
import org.apache.flink.util.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderUtilsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithURLClassLoader() {
        File validJar = null;
        File invalidJar = null;
        try {
            validJar = File.createTempFile("flink-url-test", ".tmp");
            ClassLoaderUtilsTest.createValidJar(validJar);
            try (JarFile jarFile = null;){
                jarFile = new JarFile(validJar.getAbsolutePath());
            }
            invalidJar = File.createTempFile("flink-url-test", ".tmp");
            try (FileOutputStream invalidout = new FileOutputStream(invalidJar);){
                invalidout.write(new byte[]{-1, 1, -2, 3, -3, 4});
            }
            File nonExisting = File.createTempFile("flink-url-test", ".tmp");
            Assert.assertTrue((String)"Cannot create and delete temp file", (boolean)nonExisting.delete());
            URL[] urls = new URL[]{new URL("http", "localhost", 26712, "/some/file/path"), new URL("file", null, validJar.getAbsolutePath()), new URL("file", null, invalidJar.getAbsolutePath()), new URL("file", null, nonExisting.getAbsolutePath())};
            URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
            String info = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)loader);
            Assert.assertTrue((info.indexOf("/some/file/path") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((info.indexOf(validJar.getAbsolutePath() + "' (valid") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((info.indexOf(invalidJar.getAbsolutePath() + "' (invalid JAR") > 0 ? 1 : 0) != 0);
            Assert.assertTrue((info.indexOf(nonExisting.getAbsolutePath() + "' (missing") > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (validJar != null) {
                validJar.delete();
            }
            if (invalidJar != null) {
                invalidJar.delete();
            }
        }
    }

    private static void createValidJar(File jarFile) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(jarFile);
             JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest());){
            Class<ClassLoaderUtilsTest> classToIncludeInJar = ClassLoaderUtilsTest.class;
            ClassLoaderUtilsTest.startJarEntryForClass(classToIncludeInJar, jarOutputStream);
            ClassLoaderUtilsTest.copyClassFileToJar(classToIncludeInJar, jarOutputStream);
        }
    }

    private static void startJarEntryForClass(Class<?> clazz, JarOutputStream jarOutputStream) throws IOException {
        String jarEntryName = clazz.getName().replace('.', '/') + ".class";
        jarOutputStream.putNextEntry(new JarEntry(jarEntryName));
    }

    private static void copyClassFileToJar(Class<?> clazz, JarOutputStream jarOutputStream) throws IOException {
        try (InputStream classInputStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".class");){
            IOUtils.copyBytes((InputStream)classInputStream, (OutputStream)jarOutputStream, (int)128, (boolean)false);
        }
        jarOutputStream.closeEntry();
    }

    @Test
    public void testWithAppClassLoader() {
        try {
            String result = ClassLoaderUtil.getUserCodeClassLoaderInfo((ClassLoader)ClassLoader.getSystemClassLoader());
            Assert.assertTrue((boolean)result.toLowerCase().contains("system classloader"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInvalidClassLoaders() {
        try {
            Assert.assertNotNull((Object)ClassLoaderUtil.getUserCodeClassLoaderInfo(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

