/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.CompressedSerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class CompressedSerializedValueTest {
    @Test
    public void testSimpleValue() throws Exception {
        String value = "teststring";
        CompressedSerializedValue v = CompressedSerializedValue.fromObject((Object)"teststring");
        CompressedSerializedValue copy = (CompressedSerializedValue)CommonTestUtils.createCopySerializable((Serializable)v);
        Assert.assertEquals((Object)"teststring", (Object)v.deserializeValue(this.getClass().getClassLoader()));
        Assert.assertEquals((Object)"teststring", (Object)copy.deserializeValue(this.getClass().getClassLoader()));
        Assert.assertEquals((Object)v, (Object)copy);
        Assert.assertEquals((long)v.hashCode(), (long)copy.hashCode());
        Assert.assertNotNull((Object)v.toString());
        Assert.assertNotNull((Object)copy.toString());
        Assert.assertNotEquals((long)0L, (long)v.getSize());
        Assert.assertArrayEquals((byte[])v.getByteArray(), (byte[])copy.getByteArray());
        byte[] bytes = v.getByteArray();
        CompressedSerializedValue saved = CompressedSerializedValue.fromBytes((byte[])Arrays.copyOf(bytes, bytes.length));
        Assert.assertEquals((Object)v, (Object)saved);
        Assert.assertArrayEquals((byte[])v.getByteArray(), (byte[])saved.getByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void testNullValue() throws Exception {
        CompressedSerializedValue.fromObject(null);
    }

    @Test(expected=NullPointerException.class)
    public void testFromNullBytes() {
        CompressedSerializedValue.fromBytes(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromEmptyBytes() {
        CompressedSerializedValue.fromBytes((byte[])new byte[0]);
    }
}

